/*
 * Decompiled with CFR 0.152.
 */
package okio;

import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Segment$Companion;
import okio.SegmentPool;

public final class Segment {
    public static final Segment$Companion Companion = new Segment$Companion(null);
    public final byte[] data;
    public int pos;
    public int limit;
    public boolean shared;
    public boolean owner;
    public Segment next;
    public Segment prev;

    public Segment() {
        this.data = new byte[8192];
        this.owner = true;
        this.shared = false;
    }

    public Segment(byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        Intrinsics.checkNotNullParameter(byArray, "data");
        this.data = byArray;
        this.pos = n;
        this.limit = n2;
        this.shared = bl;
        this.owner = bl2;
    }

    public final Segment sharedCopy() {
        ((Segment)object).shared = true;
        Segment segment = object;
        Object object = segment.data;
        int n = segment.pos;
        int n2 = segment.limit;
        return new Segment((byte[])object, n, n2, true, false);
    }

    public final Segment pop() {
        Segment segment = this.next;
        if (segment == this) {
            segment = null;
        }
        Segment segment2 = this;
        Intrinsics.checkNotNull(segment2.prev);
        segment2.prev.next = this.next;
        Intrinsics.checkNotNull(segment2.next);
        segment2.next.prev = this.prev;
        segment2.next = null;
        segment2.prev = null;
        return segment;
    }

    public final Segment push(Segment segment) {
        Intrinsics.checkNotNullParameter(segment, "segment");
        segment.prev = this;
        segment.next = this.next;
        Intrinsics.checkNotNull(this.next);
        this.next.prev = segment;
        this.next = segment;
        return segment;
    }

    public final Segment split(int n) {
        if (n > 0 && n <= this.limit - this.pos) {
            Segment segment;
            if (n >= 1024) {
                segment = this.sharedCopy();
            } else {
                segment = SegmentPool.take();
                byte[] byArray = segment.data;
                int n2 = this.pos;
                int n3 = n2 + n;
                ArraysKt.copyInto$default(this.data, byArray, 0, n2, n3, 2, null);
            }
            Segment segment2 = this;
            segment.limit = segment.pos + n;
            segment2.pos += n;
            Segment segment3 = segment2.prev;
            Intrinsics.checkNotNull(segment3);
            segment3.push(segment);
            return segment;
        }
        throw new IllegalArgumentException("byteCount out of range".toString());
    }

    public final void compact() {
        Segment segment = segment8.prev;
        if (segment != segment8) {
            int n;
            Segment segment2 = segment;
            Intrinsics.checkNotNull(segment2);
            if (!segment2.owner) {
                return;
            }
            Segment segment3 = segment8;
            int n2 = segment3.limit - segment8.pos;
            Segment segment4 = segment3.prev;
            Intrinsics.checkNotNull(segment4);
            int n3 = 8192 - segment4.limit;
            Segment segment5 = segment3.prev;
            Intrinsics.checkNotNull(segment5);
            if (segment5.shared) {
                n = 0;
            } else {
                Segment segment6 = segment8.prev;
                Intrinsics.checkNotNull(segment6);
                n = segment6.pos;
            }
            if (n2 > n3 + n) {
                return;
            }
            Segment segment7 = segment8;
            Segment segment8 = segment7.prev;
            Intrinsics.checkNotNull(segment8);
            segment7.writeTo(segment8, n2);
            segment7.pop();
            SegmentPool.recycle(segment7);
            return;
        }
        throw new IllegalStateException("cannot compact".toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void writeTo(Segment segment, int n) {
        Segment segment2 = segment;
        Intrinsics.checkNotNullParameter(segment2, "sink");
        if (!segment2.owner) throw new IllegalStateException("only owner can write".toString());
        int n2 = segment.limit;
        if (n2 + n > 8192) {
            if (segment.shared) throw new IllegalArgumentException();
            int n3 = segment.pos;
            if (n2 + n - n3 > 8192) throw new IllegalArgumentException();
            Segment segment3 = segment;
            ArraysKt.copyInto$default(segment3.data, segment3.data, 0, n3, n2, 2, null);
            segment3.limit -= segment.pos;
            segment3.pos = 0;
        }
        Segment segment4 = object;
        Segment segment5 = object;
        Segment segment6 = segment;
        Object object = segment6.data;
        int n4 = segment6.limit;
        n2 = segment5.pos;
        int n5 = n2 + n;
        ArraysKt.copyInto(((Segment)object).data, (byte[])object, n4, n2, n5);
        segment.limit += n;
        segment4.pos += n;
    }
}

