/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.ByteString$Companion;
import okio._Base64Kt;
import okio._JvmPlatformKt;
import okio._UtilKt;
import okio.internal._ByteStringKt;

public class ByteString
implements Serializable,
Comparable {
    public static final ByteString$Companion Companion = new ByteString$Companion(null);
    public static final ByteString EMPTY = new ByteString(new byte[0]);
    private final byte[] data;
    private transient int hashCode;
    private transient String utf8;

    public ByteString(byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "data");
        this.data = byArray;
    }

    public static /* synthetic */ ByteString substring$default(ByteString byteString, int n, int n2, int n3, Object object) {
        if (object == null) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = _UtilKt.getDEFAULT__ByteString_size();
            }
            return byteString.substring(n, n2);
        }
        throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: substring");
    }

    public static /* synthetic */ int indexOf$default(ByteString byteString, ByteString byteString2, int n, int n2, Object object) {
        if (object == null) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return byteString.indexOf(byteString2, n);
        }
        throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexOf");
    }

    public static /* synthetic */ int lastIndexOf$default(ByteString byteString, ByteString byteString2, int n, int n2, Object object) {
        if (object == null) {
            if ((n2 & 2) != 0) {
                n = _UtilKt.getDEFAULT__ByteString_size();
            }
            return byteString.lastIndexOf(byteString2, n);
        }
        throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: lastIndexOf");
    }

    public final byte[] getData$okio() {
        return this.data;
    }

    public final int getHashCode$okio() {
        return this.hashCode;
    }

    public final void setHashCode$okio(int n) {
        this.hashCode = n;
    }

    public final String getUtf8$okio() {
        return this.utf8;
    }

    public final void setUtf8$okio(String string) {
        this.utf8 = string;
    }

    public String utf8() {
        String string = this.getUtf8$okio();
        if (string == null) {
            ByteString byteString = this;
            string = _JvmPlatformKt.toUtf8String(byteString.internalArray$okio());
            byteString.setUtf8$okio(string);
        }
        return string;
    }

    public String string(Charset charset) {
        Intrinsics.checkNotNullParameter(charset, "charset");
        return new String(this.data, charset);
    }

    public String base64() {
        return _Base64Kt.encodeBase64$default(this.getData$okio(), null, 1, null);
    }

    public final ByteString sha256() {
        return this.digest$okio("SHA-256");
    }

    public ByteString digest$okio(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "algorithm");
        MessageDigest messageDigest = MessageDigest.getInstance(string2);
        ByteString byteString = object;
        Object object = byteString.data;
        int n = byteString.size();
        messageDigest.update((byte[])object, 0, n);
        object = messageDigest.digest();
        Intrinsics.checkNotNullExpressionValue(object, "digestBytes");
        return new ByteString((byte[])object);
    }

    public String hex() {
        ByteString byteString = object;
        Object object = new char[byteString.getData$okio().length * 2];
        int n = 0;
        byte[] byArray = byteString.getData$okio();
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            Object object2 = object;
            byte by = byArray[i];
            object2[n++] = _ByteStringKt.getHEX_DIGIT_CHARS()[by >> 4 & 0xF];
            object2[n++] = _ByteStringKt.getHEX_DIGIT_CHARS()[by & 0xF];
        }
        return StringsKt.concatToString((char[])object);
    }

    public ByteString toAsciiLowercase() {
        for (int i = 0; i < ((ByteString)object2).getData$okio().length; ++i) {
            ByteString byteString;
            byte by;
            byte by2;
            Object object = ((ByteString)object2).getData$okio()[i];
            if (object < (by2 = (byte)65) || object > (by = (byte)90)) continue;
            byte[] byArray = ((ByteString)object2).getData$okio();
            byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
            Object object2 = byArray2;
            Intrinsics.checkNotNullExpressionValue(object2, "copyOf(this, size)");
            byArray2[i++] = (byte)(object - -32);
            while (i < ((Object)object2).length) {
                Object object3 = object2[i];
                object = object3;
                if (object3 >= by2 && object <= by) {
                    object2[i] = (byte)(object - -32);
                    ++i;
                    continue;
                }
                ++i;
            }
            ByteString byteString2 = byteString;
            byteString = new ByteString((byte[])object2);
            object2 = byteString2;
            break;
        }
        return object2;
    }

    public ByteString substring(int n, int n2) {
        n2 = _UtilKt.resolveDefaultParameter((ByteString)object, n2);
        if (n >= 0) {
            Object object;
            if (n2 <= ((ByteString)object).getData$okio().length) {
                if (n2 - n >= 0) {
                    if (n != 0 || n2 != ((ByteString)object).getData$okio().length) {
                        ByteString byteString;
                        ByteString byteString2 = byteString;
                        byteString = new ByteString(ArraysKt.copyOfRange(((ByteString)object).getData$okio(), n, n2));
                        object = byteString2;
                    }
                    return object;
                }
                throw new IllegalArgumentException("endIndex < beginIndex".toString());
            }
            object = "endIndex > length(" + ((ByteString)object).getData$okio().length + ')';
            throw new IllegalArgumentException(object.toString());
        }
        throw new IllegalArgumentException("beginIndex < 0".toString());
    }

    public byte internalGet$okio(int n) {
        return this.getData$okio()[n];
    }

    public final byte getByte(int n) {
        return this.internalGet$okio(n);
    }

    public final int size() {
        return this.getSize$okio();
    }

    public int getSize$okio() {
        return this.getData$okio().length;
    }

    public byte[] internalArray$okio() {
        return this.getData$okio();
    }

    public void write$okio(Buffer buffer, int n, int n2) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        _ByteStringKt.commonWrite(this, buffer, n, n2);
    }

    public boolean rangeEquals(int n, ByteString byteString, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byteString, "other");
        return byteString.rangeEquals(n2, this.getData$okio(), n, n3);
    }

    public boolean rangeEquals(int n, byte[] byArray, int n2, int n3) {
        Intrinsics.checkNotNullParameter(byArray, "other");
        return n >= 0 && n <= this.getData$okio().length - n3 && n2 >= 0 && n2 <= byArray.length - n3 && _UtilKt.arrayRangeEquals(this.getData$okio(), n, byArray, n2, n3);
    }

    public final boolean startsWith(ByteString byteString) {
        ByteString byteString2 = byteString;
        Intrinsics.checkNotNullParameter(byteString2, "prefix");
        int n = byteString2.size();
        return this.rangeEquals(0, byteString, 0, n);
    }

    public final boolean endsWith(ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "suffix");
        int n = this.size() - byteString.size();
        int n2 = byteString.size();
        return this.rangeEquals(n, byteString, 0, n2);
    }

    public final int indexOf(ByteString byteString, int n) {
        ByteString byteString2 = byteString;
        Intrinsics.checkNotNullParameter(byteString2, "other");
        return this.indexOf(byteString2.internalArray$okio(), n);
    }

    public int indexOf(byte[] byArray, int n) {
        int n2 = n;
        Intrinsics.checkNotNullParameter(byArray, "other");
        n = this.getData$okio().length - byArray.length;
        int n3 = Math.max(n2, 0);
        if (n3 <= n) {
            while (true) {
                int n4 = byArray.length;
                if (!_UtilKt.arrayRangeEquals(this.getData$okio(), n3, byArray, 0, n4)) {
                    if (n3 == n) break;
                    ++n3;
                    continue;
                }
                break;
            }
        } else {
            n3 = -1;
        }
        return n3;
    }

    public final int lastIndexOf(ByteString byteString, int n) {
        ByteString byteString2 = byteString;
        Intrinsics.checkNotNullParameter(byteString2, "other");
        return this.lastIndexOf(byteString2.internalArray$okio(), n);
    }

    public int lastIndexOf(byte[] byArray, int n) {
        block2: {
            Intrinsics.checkNotNullParameter(byArray, "other");
            for (n = Math.min(_UtilKt.resolveDefaultParameter(this, n), this.getData$okio().length - byArray.length); -1 < n; --n) {
                int n2 = byArray.length;
                if (!_UtilKt.arrayRangeEquals(this.getData$okio(), n, byArray, 0, n2)) {
                    continue;
                }
                break block2;
            }
            n = -1;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        int n;
        if (object == object2) {
            return true;
        }
        if (!(object instanceof ByteString)) return false;
        if (((ByteString)(object = (ByteString)object)).size() != ((ByteString)object2).getData$okio().length) return false;
        ByteString byteString = object2;
        Object object2 = byteString.getData$okio();
        if (!((ByteString)object).rangeEquals(0, (byte[])object2, 0, n = byteString.getData$okio().length)) return false;
        return true;
    }

    public int hashCode() {
        int n = this.getHashCode$okio();
        if (n == 0) {
            ByteString byteString = this;
            n = Arrays.hashCode(byteString.getData$okio());
            byteString.setHashCode$okio(n);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compareTo(ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "other");
        int n = this.size();
        int n2 = byteString.size();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5 = this.getByte(i) & 0xFF;
            if (n5 == (n4 = byteString.getByte(i) & 0xFF)) {
                continue;
            }
            if (n5 >= n4) return 1;
            return -1;
        }
        if (n == n2) {
            return 0;
        }
        if (n >= n2) return 1;
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        if (((ByteString)object).getData$okio().length == 0) {
            return "[size=0]";
        }
        boolean bl = false;
        if (bl) {
            return "[size=0]";
        }
        int n = _ByteStringKt.access$codePointIndexToCharIndex(((ByteString)object).getData$okio(), 64);
        if (n == -1) {
            Object object;
            if (((ByteString)object).getData$okio().length <= 64) {
                return "[hex=" + ((ByteString)object).hex() + ']';
            }
            StringBuilder stringBuilder = new StringBuilder().append("[size=").append(((ByteString)object).getData$okio().length).append(" hex=");
            int n2 = 0;
            int n3 = _UtilKt.resolveDefaultParameter((ByteString)object, 64);
            if (n3 <= ((ByteString)object).getData$okio().length) {
                ByteString byteString;
                if (!(n3 - n2 >= 0)) throw new IllegalArgumentException("endIndex < beginIndex".toString());
                if (n3 == ((ByteString)object).getData$okio().length) return stringBuilder.append(((ByteString)object).hex()).append("\u2026]").toString();
                ByteString byteString2 = byteString;
                byteString = new ByteString(ArraysKt.copyOfRange(((ByteString)object).getData$okio(), n2, n3));
                object = byteString2;
                return stringBuilder.append(((ByteString)object).hex()).append("\u2026]").toString();
            }
            object = "endIndex > length(" + ((ByteString)object).getData$okio().length + ')';
            throw new IllegalArgumentException(object.toString());
        }
        String string = ((ByteString)object).utf8();
        String string2 = string.substring(0, n);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        String string3 = StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(string2, "\\", "\\\\", false, 4, null), "\n", "\\n", false, 4, null), "\r", "\\r", false, 4, null);
        if (n >= string.length()) return "[text=" + string3 + ']';
        return "[size=" + ((ByteString)object).getData$okio().length + " text=" + string3 + "\u2026]";
    }
}

