/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.internal.platform.Platform$Companion;
import okhttp3.internal.tls.BasicCertificateChainCleaner;
import okhttp3.internal.tls.BasicTrustRootIndex;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;

public class Platform {
    public static final Platform$Companion Companion = new Platform$Companion(null);
    private static volatile Platform platform = Platform$Companion.access$findPlatform(Companion);
    private static final Logger logger = Logger.getLogger(OkHttpClient.class.getName());

    public static /* synthetic */ void log$default(Platform platform, String string, int n, Throwable throwable, int n2, Object object) {
        if (object == null) {
            if ((n2 & 2) != 0) {
                n = 4;
            }
            if ((n2 & 4) != 0) {
                throwable = null;
            }
            platform.log(string, n, throwable);
            return;
        }
        throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: log");
    }

    public static final /* synthetic */ Platform access$getPlatform$cp() {
        return platform;
    }

    public SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        Intrinsics.checkNotNullExpressionValue(sSLContext, "getInstance(\"TLS\")");
        return sSLContext;
    }

    public X509TrustManager platformTrustManager() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        Object object = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNull(object);
        if (((TrustManager[])object).length == 1 && object[0] instanceof X509TrustManager) {
            if ((object = object[0]) != null) {
                return (X509TrustManager)object;
            }
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        object = Arrays.toString((Object[])object);
        Intrinsics.checkNotNullExpressionValue(object, "toString(this)");
        object = Intrinsics.stringPlus("Unexpected default trust managers: ", object);
        throw new IllegalStateException(object.toString());
    }

    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List list) {
        Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
        Intrinsics.checkNotNullParameter(list, "protocols");
    }

    public void afterHandshake(SSLSocket sSLSocket) {
        Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
    }

    public String getSelectedProtocol(SSLSocket sSLSocket) {
        Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n) {
        Intrinsics.checkNotNullParameter(socket, "socket");
        Intrinsics.checkNotNullParameter(inetSocketAddress, "address");
        socket.connect(inetSocketAddress, n);
    }

    public void log(String string, int n, Throwable throwable) {
        Intrinsics.checkNotNullParameter(string, "message");
        Level level = n == 5 ? Level.WARNING : Level.INFO;
        logger.log(level, string, throwable);
    }

    public boolean isCleartextTrafficPermitted(String string) {
        Intrinsics.checkNotNullParameter(string, "hostname");
        return true;
    }

    public Object getStackTraceForCloseable(String string) {
        Object object;
        Intrinsics.checkNotNullParameter(string, "closer");
        if (logger.isLoggable(Level.FINE)) {
            Throwable throwable;
            object = throwable;
            throwable = new Throwable(string);
        } else {
            object = null;
        }
        return object;
    }

    public void logCloseableLeak(String string, Object object) {
        Intrinsics.checkNotNullParameter(string, "message");
        if (object == null) {
            string = Intrinsics.stringPlus(string, " To see where this was allocated, set the OkHttpClient logger level to FINE: Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);");
        }
        Platform platform = throwable;
        Throwable throwable = (Throwable)object;
        platform.log(string, 5, throwable);
    }

    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        Intrinsics.checkNotNullParameter(x509TrustManager, "trustManager");
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex(x509TrustManager));
    }

    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        Intrinsics.checkNotNullParameter(x509TrustManager, "trustManager");
        X509Certificate[] x509CertificateArray = x509TrustManager.getAcceptedIssuers();
        Intrinsics.checkNotNullExpressionValue(x509CertificateArray, "trustManager.acceptedIssuers");
        return new BasicTrustRootIndex(Arrays.copyOf(x509CertificateArray, x509CertificateArray.length));
    }

    public SSLSocketFactory newSslSocketFactory(X509TrustManager x509TrustManager) {
        SSLContext sSLContext;
        Intrinsics.checkNotNullParameter(x509TrustManager, "trustManager");
        try {
            sSLContext = this.newSSLContext();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AssertionError(Intrinsics.stringPlus("No System TLS: ", generalSecurityException), generalSecurityException);
        }
        TrustManager[] trustManagerArray = new TrustManager[1];
        trustManagerArray[0] = x509TrustManager;
        sSLContext.init(null, trustManagerArray, null);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue(sSLSocketFactory, "newSSLContext().apply {\n\u2026ll)\n      }.socketFactory");
        return sSLSocketFactory;
    }

    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string, "javaClass.simpleName");
        return string;
    }
}

