/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.os.Build;
import android.security.NetworkSecurityPolicy;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.platform.AndroidPlatform$Companion;
import okhttp3.internal.platform.AndroidPlatform$CustomTrustRootIndex;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.AndroidCertificateChainCleaner;
import okhttp3.internal.platform.android.AndroidSocketAdapter;
import okhttp3.internal.platform.android.BouncyCastleSocketAdapter;
import okhttp3.internal.platform.android.CloseGuard;
import okhttp3.internal.platform.android.ConscryptSocketAdapter;
import okhttp3.internal.platform.android.DeferredSocketAdapter;
import okhttp3.internal.platform.android.SocketAdapter;
import okhttp3.internal.platform.android.StandardAndroidSocketAdapter;
import okhttp3.internal.platform.android.StandardAndroidSocketAdapter$Companion;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;

public final class AndroidPlatform
extends Platform {
    public static final AndroidPlatform$Companion Companion;
    private static final boolean isSupported;
    private final List socketAdapters;
    private final CloseGuard closeGuard;

    public AndroidPlatform() {
        ArrayList arrayList;
        DeferredSocketAdapter deferredSocketAdapter;
        DeferredSocketAdapter deferredSocketAdapter2;
        DeferredSocketAdapter deferredSocketAdapter3;
        Object[] objectArray = new SocketAdapter[4];
        objectArray[0] = StandardAndroidSocketAdapter$Companion.buildIfSupported$default(StandardAndroidSocketAdapter.Companion, null, 1, null);
        Object object = deferredSocketAdapter3;
        deferredSocketAdapter3 = new DeferredSocketAdapter(AndroidSocketAdapter.Companion.getPlayProviderFactory());
        objectArray[1] = object;
        object = deferredSocketAdapter2;
        deferredSocketAdapter2 = new DeferredSocketAdapter(ConscryptSocketAdapter.Companion.getFactory());
        objectArray[2] = object;
        object = deferredSocketAdapter;
        deferredSocketAdapter = new DeferredSocketAdapter(BouncyCastleSocketAdapter.Companion.getFactory());
        objectArray[3] = object;
        object = arrayList;
        arrayList = new ArrayList();
        for (Object t : CollectionsKt.listOfNotNull(objectArray)) {
            if (!((SocketAdapter)t).isSupported()) continue;
            object.add(t);
        }
        AndroidPlatform androidPlatform = this;
        androidPlatform.socketAdapters = object;
        androidPlatform.closeGuard = CloseGuard.Companion.get();
    }

    public static final /* synthetic */ boolean access$isSupported$cp() {
        return isSupported;
    }

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl;
        Companion = new AndroidPlatform$Companion(null);
        if (!Platform.Companion.isAndroid() || Build.VERSION.SDK_INT >= 30) {
            bl = false;
        } else {
            if (!(Build.VERSION.SDK_INT >= 21)) {
                String string = Intrinsics.stringPlus("Expected Android API level 21+ but was ", Build.VERSION.SDK_INT);
                throw new IllegalStateException(string.toString());
            }
            bl = true;
        }
        isSupported = bl;
    }

    @Override
    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n) {
        Intrinsics.checkNotNullParameter(socket, "socket");
        Intrinsics.checkNotNullParameter(inetSocketAddress, "address");
        try {
            socket.connect(inetSocketAddress, n);
            return;
        }
        catch (ClassCastException classCastException) {
            if (Build.VERSION.SDK_INT == 26) {
                throw new IOException("Exception in connect", classCastException);
            }
            throw classCastException;
        }
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List list) {
        Object var4_4;
        block2: {
            Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
            Intrinsics.checkNotNullParameter(list, "protocols");
            for (Object e : ((AndroidPlatform)((Object)socketAdapter)).socketAdapters) {
                var4_4 = e;
                if (!((SocketAdapter)e).matchesSocket(sSLSocket)) continue;
                break block2;
            }
            var4_4 = null;
        }
        SocketAdapter socketAdapter = var4_4;
        if (socketAdapter != null) {
            socketAdapter.configureTlsExtensions(sSLSocket, string, list);
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        Object var2_2;
        block1: {
            Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
            for (Object e : ((AndroidPlatform)((Object)socketAdapter)).socketAdapters) {
                var2_2 = e;
                if (!((SocketAdapter)e).matchesSocket(sSLSocket)) continue;
                break block1;
            }
            var2_2 = null;
        }
        SocketAdapter socketAdapter = var2_2;
        return socketAdapter == null ? null : socketAdapter.getSelectedProtocol(sSLSocket);
    }

    @Override
    public Object getStackTraceForCloseable(String string) {
        Intrinsics.checkNotNullParameter(string, "closer");
        return this.closeGuard.createAndOpen(string);
    }

    @Override
    public void logCloseableLeak(String string, Object object) {
        Intrinsics.checkNotNullParameter(string, "message");
        if (!this.closeGuard.warnIfOpen(object)) {
            Platform.log$default(this, string, 5, null, 4, null);
        }
    }

    @Override
    public boolean isCleartextTrafficPermitted(String string) {
        Intrinsics.checkNotNullParameter(string, "hostname");
        return Build.VERSION.SDK_INT >= 24 ? NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(string) : (Build.VERSION.SDK_INT >= 23 ? NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted() : true);
    }

    @Override
    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        Intrinsics.checkNotNullParameter(x509TrustManager, "trustManager");
        CertificateChainCleaner certificateChainCleaner = AndroidCertificateChainCleaner.Companion.buildIfSupported(x509TrustManager);
        if (certificateChainCleaner == null) {
            certificateChainCleaner = super.buildCertificateChainCleaner(x509TrustManager);
        }
        return certificateChainCleaner;
    }

    @Override
    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        AndroidPlatform$CustomTrustRootIndex androidPlatform$CustomTrustRootIndex;
        X509TrustManager x509TrustManager2 = x509TrustManager;
        Intrinsics.checkNotNullParameter(x509TrustManager2, "trustManager");
        Class<?> clazz = x509TrustManager2.getClass();
        String string = "findTrustAnchorByIssuerAndSignature";
        Class[] classArray = new Class[1];
        classArray[0] = X509Certificate.class;
        Method method = clazz.getDeclaredMethod(string, classArray);
        method.setAccessible(true);
        TrustRootIndex trustRootIndex = androidPlatform$CustomTrustRootIndex;
        try {
            Method method2 = method;
            Intrinsics.checkNotNullExpressionValue(method2, "method");
            androidPlatform$CustomTrustRootIndex = new AndroidPlatform$CustomTrustRootIndex(x509TrustManager, method2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            trustRootIndex = super.buildTrustRootIndex(x509TrustManager);
        }
        return trustRootIndex;
    }
}

