/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.EOFException;
import java.io.IOException;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.StreamResetException;
import okio.Buffer;
import okio.BufferedSource;
import okio.Source;
import okio.Timeout;

public final class Http2Stream$FramingSource
implements Source {
    private final long maxByteCount;
    private boolean finished;
    private final Buffer receiveBuffer;
    private final Buffer readBuffer;
    private Headers trailers;
    private boolean closed;
    final /* synthetic */ Http2Stream this$0;

    public Http2Stream$FramingSource(Http2Stream http2Stream, long l, boolean bl) {
        Buffer buffer;
        Buffer buffer2;
        Intrinsics.checkNotNullParameter(http2Stream, "this$0");
        source2.this$0 = http2Stream;
        source2.maxByteCount = l;
        source2.finished = bl;
        Source source2 = buffer2;
        buffer2 = new Buffer();
        v1.receiveBuffer = source2;
        source2 = buffer;
        buffer = new Buffer();
        v1.readBuffer = source2;
    }

    private final void updateConnectionFlowControl(long l) {
        Http2Stream http2Stream = this.this$0;
        if (Util.assertionsEnabled && Thread.holdsLock(http2Stream)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + http2Stream));
        }
        this.this$0.getConnection().updateConnectionFlowControl$okhttp(l);
    }

    public final boolean getFinished$okhttp() {
        return this.finished;
    }

    public final void setFinished$okhttp(boolean bl) {
        this.finished = bl;
    }

    public final Buffer getReceiveBuffer() {
        return this.receiveBuffer;
    }

    public final Buffer getReadBuffer() {
        return this.readBuffer;
    }

    public final void setTrailers(Headers headers) {
        this.trailers = headers;
    }

    public final boolean getClosed$okhttp() {
        return this.closed;
    }

    public final void setClosed$okhttp(boolean bl) {
        this.closed = bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public long read(Buffer var1_2, long var2_3) {
        block16: {
            Intrinsics.checkNotNullParameter(var1_2, "sink");
            if (!(var2_3 >= 0L)) {
                this = Intrinsics.stringPlus("byteCount < 0: ", var2_3);
                throw new IllegalArgumentException(this.toString());
            }
            do {
                block17: {
                    var4_4 = false;
                    var5_5 = -1L;
                    var7_6 = null;
                    var8_7 = this.this$0;
                    // MONITORENTER : var8_7
                    var8_7.getReadTimeout$okhttp().enter();
                    if (var8_7.getErrorCode$okhttp() == null || (var7_6 = var8_7.getErrorException$okhttp()) != null) ** GOTO lbl21
                    var7_6 = v0;
                    var9_8 = var8_7.getErrorCode$okhttp();
                    Intrinsics.checkNotNull((Object)var9_8);
                    v0 = new StreamResetException(var9_8);
lbl21:
                    // 2 sources

                    if (this.getClosed$okhttp()) break block16;
                    if (this.getReadBuffer().size() <= 0L) ** GOTO lbl34
                    v1 = var8_7;
                    var5_5 = this.getReadBuffer().read(var1_2, Math.min(var2_3, this.getReadBuffer().size()));
                    v1.setReadBytesTotal$okhttp(v1.getReadBytesTotal() + var5_5);
                    var9_9 = v1.getReadBytesTotal() - var8_7.getReadBytesAcknowledged();
                    if (var7_6 != null) break block17;
                    if (var9_9 >= (long)(var8_7.getConnection().getOkHttpSettings().getInitialWindowSize() / 2)) {
                        v2 = var8_7;
                        v2.getConnection().writeWindowUpdateLater$okhttp(var8_7.getId(), var9_9);
                        v2.setReadBytesAcknowledged$okhttp(v2.getReadBytesTotal());
                    }
                    break block17;
lbl34:
                    // 1 sources

                    if (this.getFinished$okhttp() || var7_6 != null) break block17;
                    var8_7.waitForIo$okhttp();
                    var4_4 = true;
                }
                v3 = var4_4;
                v4 = var8_7;
                v5 = v4;
                v4.getReadTimeout$okhttp().exitAndThrowIfTimedOut();
            } while (v3);
            if (var5_5 != -1L) {
                super.updateConnectionFlowControl(var5_5);
                return var5_5;
            }
            if (var7_6 != null) throw var7_6;
            return -1L;
        }
        try {
            throw new IOException("stream closed");
        }
        catch (Throwable var0_1) {
            var8_7.getReadTimeout$okhttp().exitAndThrowIfTimedOut();
            throw var0_1;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void receive$okhttp(BufferedSource bufferedSource, long l) {
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        Http2Stream http2Stream = this.this$0;
        if (Util.assertionsEnabled) {
            if (Thread.holdsLock(http2Stream)) throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + http2Stream));
        }
        while (l > 0L) {
            long l2;
            block13: {
                Http2Stream$FramingSource http2Stream$FramingSource = this;
                http2Stream = http2Stream$FramingSource.this$0;
                // MONITORENTER : http2Stream
                boolean bl = http2Stream$FramingSource.getFinished$okhttp();
                boolean bl2 = l + http2Stream$FramingSource.getReadBuffer().size() > this.maxByteCount;
                boolean bl3 = bl2;
                Http2Stream http2Stream2 = http2Stream;
                // MONITOREXIT : http2Stream2
                if (bl3) {
                    bufferedSource.skip(l);
                    this.this$0.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                    return;
                }
                if (bl) {
                    bufferedSource.skip(l);
                    return;
                }
                l2 = bufferedSource.read(this.receiveBuffer, l);
                if (l2 == -1L) throw new EOFException();
                Http2Stream$FramingSource http2Stream$FramingSource2 = this;
                l -= l2;
                l2 = 0L;
                Http2Stream http2Stream3 = http2Stream$FramingSource2.this$0;
                // MONITORENTER : http2Stream3
                if (http2Stream$FramingSource2.getClosed$okhttp()) {
                    Http2Stream$FramingSource http2Stream$FramingSource3 = this;
                    l2 = http2Stream$FramingSource3.getReceiveBuffer().size();
                    http2Stream$FramingSource3.getReceiveBuffer().clear();
                    break block13;
                }
                boolean bl4 = this.getReadBuffer().size() == 0L;
                boolean bl5 = bl4;
                this.getReadBuffer().writeAll(this.getReceiveBuffer());
                if (bl5) {
                    http2Stream3.notifyAll();
                }
            }
            // MONITOREXIT : http2Stream3
            if (l2 <= 0L) continue;
            this.updateConnectionFlowControl(l2);
        }
        return;
        catch (Throwable throwable) {
            // MONITOREXIT : http2Stream3
            throw throwable;
        }
        catch (Throwable throwable) {
            // MONITOREXIT : http2Stream
            throw throwable;
        }
    }

    @Override
    public Timeout timeout() {
        return this.this$0.getReadTimeout$okhttp();
    }

    @Override
    public void close() {
        Http2Stream$FramingSource http2Stream$FramingSource = this;
        Http2Stream http2Stream = http2Stream$FramingSource.this$0;
        synchronized (http2Stream) {
            http2Stream$FramingSource.setClosed$okhttp(true);
            long l = http2Stream$FramingSource.getReadBuffer().size();
            Http2Stream http2Stream2 = http2Stream;
            Http2Stream http2Stream3 = http2Stream2;
            this.getReadBuffer().clear();
            http2Stream2.notifyAll();
            if (l > 0L) {
                this.updateConnectionFlowControl(l);
            }
            this.this$0.cancelStreamIfNecessary$okhttp();
            return;
        }
    }
}

