/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Response$Builder;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2ExchangeCodec$Companion;
import okhttp3.internal.http2.Http2Stream;
import okio.Sink;
import okio.Source;

public final class Http2ExchangeCodec
implements ExchangeCodec {
    public static final Http2ExchangeCodec$Companion Companion = new Http2ExchangeCodec$Companion(null);
    private static final List HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableListOf("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade", ":method", ":path", ":scheme", ":authority");
    private static final List HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableListOf("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade");
    private final RealConnection connection;
    private final RealInterceptorChain chain;
    private final Http2Connection http2Connection;
    private volatile Http2Stream stream;
    private final Protocol protocol;
    private volatile boolean canceled;

    public Http2ExchangeCodec(OkHttpClient object, RealConnection realConnection, RealInterceptorChain realInterceptorChain, Http2Connection http2Connection) {
        Intrinsics.checkNotNullParameter(object, "client");
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        Intrinsics.checkNotNullParameter(realInterceptorChain, "chain");
        Intrinsics.checkNotNullParameter(http2Connection, "http2Connection");
        this.connection = realConnection;
        this.chain = realInterceptorChain;
        this.http2Connection = http2Connection;
        List list = object.protocols();
        object = Protocol.H2_PRIOR_KNOWLEDGE;
        if (!list.contains(object)) {
            object = Protocol.HTTP_2;
        }
        this.protocol = object;
    }

    public static final /* synthetic */ List access$getHTTP_2_SKIPPED_REQUEST_HEADERS$cp() {
        return HTTP_2_SKIPPED_REQUEST_HEADERS;
    }

    public static final /* synthetic */ List access$getHTTP_2_SKIPPED_RESPONSE_HEADERS$cp() {
        return HTTP_2_SKIPPED_RESPONSE_HEADERS;
    }

    @Override
    public RealConnection getConnection() {
        return this.connection;
    }

    @Override
    public Sink createRequestBody(Request request, long l) {
        Intrinsics.checkNotNullParameter(request, "request");
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        return http2Stream.getSink();
    }

    @Override
    public void writeRequestHeaders(Request object) {
        Intrinsics.checkNotNullParameter(object, "request");
        if (this.stream != null) {
            return;
        }
        boolean bl = ((Request)object).body() != null;
        Http2ExchangeCodec http2ExchangeCodec = this;
        object = Companion.http2HeadersList((Request)object);
        http2ExchangeCodec.stream = http2ExchangeCodec.http2Connection.newStream((List)object, bl);
        if (!http2ExchangeCodec.canceled) {
            Http2ExchangeCodec http2ExchangeCodec2 = this;
            Http2Stream http2Stream = http2ExchangeCodec2.stream;
            Intrinsics.checkNotNull(http2Stream);
            object = TimeUnit.MILLISECONDS;
            http2Stream.readTimeout().timeout(this.chain.getReadTimeoutMillis$okhttp(), (TimeUnit)((Object)object));
            Http2Stream http2Stream2 = http2ExchangeCodec2.stream;
            Intrinsics.checkNotNull(http2Stream2);
            http2Stream2.writeTimeout().timeout(this.chain.getWriteTimeoutMillis$okhttp(), (TimeUnit)((Object)object));
            return;
        }
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        http2Stream.closeLater(ErrorCode.CANCEL);
        throw new IOException("Canceled");
    }

    @Override
    public void flushRequest() {
        this.http2Connection.flush();
    }

    @Override
    public void finishRequest() {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        http2Stream.getSink().close();
    }

    @Override
    public Response$Builder readResponseHeaders(boolean bl) {
        Http2Stream http2Stream = ((Http2ExchangeCodec)object).stream;
        Intrinsics.checkNotNull(http2Stream);
        Object object = Companion.readHttp2HeadersList(http2Stream.takeHeaders(), ((Http2ExchangeCodec)object).protocol);
        if (bl && ((Response$Builder)object).getCode$okhttp() == 100) {
            object = null;
        }
        return object;
    }

    @Override
    public long reportedContentLength(Response response) {
        Response response2 = response;
        Intrinsics.checkNotNullParameter(response2, "response");
        return !HttpHeaders.promisesBody(response2) ? 0L : Util.headersContentLength(response);
    }

    @Override
    public Source openResponseBodySource(Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        return http2Stream.getSource$okhttp();
    }

    @Override
    public void cancel() {
        ((Http2ExchangeCodec)((Object)http2Stream)).canceled = true;
        Http2Stream http2Stream = ((Http2ExchangeCodec)((Object)http2Stream)).stream;
        if (http2Stream != null) {
            http2Stream.closeLater(ErrorCode.CANCEL);
        }
    }
}

