/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Interceptor$Chain;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealCall;

public final class RealInterceptorChain
implements Interceptor$Chain {
    private final RealCall call;
    private final List interceptors;
    private final int index;
    private final Exchange exchange;
    private final Request request;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final int writeTimeoutMillis;
    private int calls;

    public RealInterceptorChain(RealCall realCall, List list, int n, Exchange exchange, Request request, int n2, int n3, int n4) {
        Intrinsics.checkNotNullParameter(realCall, "call");
        Intrinsics.checkNotNullParameter(list, "interceptors");
        Intrinsics.checkNotNullParameter(request, "request");
        this.call = realCall;
        this.interceptors = list;
        this.index = n;
        this.exchange = exchange;
        this.request = request;
        this.connectTimeoutMillis = n2;
        this.readTimeoutMillis = n3;
        this.writeTimeoutMillis = n4;
    }

    public static /* synthetic */ RealInterceptorChain copy$okhttp$default(RealInterceptorChain realInterceptorChain, int n, Exchange exchange, Request request, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = realInterceptorChain.index;
        }
        if ((n5 & 2) != 0) {
            exchange = realInterceptorChain.exchange;
        }
        if ((n5 & 4) != 0) {
            request = realInterceptorChain.request;
        }
        if ((n5 & 8) != 0) {
            n2 = realInterceptorChain.connectTimeoutMillis;
        }
        if ((n5 & 0x10) != 0) {
            n3 = realInterceptorChain.readTimeoutMillis;
        }
        if ((n5 & 0x20) != 0) {
            n4 = realInterceptorChain.writeTimeoutMillis;
        }
        return realInterceptorChain.copy$okhttp(n, exchange, request, n2, n3, n4);
    }

    public final RealCall getCall$okhttp() {
        return this.call;
    }

    public final Exchange getExchange$okhttp() {
        return this.exchange;
    }

    public final Request getRequest$okhttp() {
        return this.request;
    }

    public final int getConnectTimeoutMillis$okhttp() {
        return this.connectTimeoutMillis;
    }

    public final int getReadTimeoutMillis$okhttp() {
        return this.readTimeoutMillis;
    }

    public final int getWriteTimeoutMillis$okhttp() {
        return this.writeTimeoutMillis;
    }

    public final RealInterceptorChain copy$okhttp(int n, Exchange exchange, Request request, int n2, int n3, int n4) {
        Intrinsics.checkNotNullParameter(request, "request");
        RealInterceptorChain realInterceptorChain = realCall;
        RealCall realCall = realInterceptorChain.call;
        return new RealInterceptorChain(realCall, realInterceptorChain.interceptors, n, exchange, request, n2, n3, n4);
    }

    @Override
    public Interceptor$Chain withConnectTimeout(int n, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)timeUnit, "unit");
        if (this.exchange == null) {
            long l = n;
            int n2 = Util.checkDuration("connectTimeout", l, timeUnit);
            return RealInterceptorChain.copy$okhttp$default(this, 0, null, null, n2, 0, 0, 55, null);
        }
        throw new IllegalStateException("Timeouts can't be adjusted in a network interceptor".toString());
    }

    public int readTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    @Override
    public Interceptor$Chain withReadTimeout(int n, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)timeUnit, "unit");
        if (this.exchange == null) {
            long l = n;
            int n2 = Util.checkDuration("readTimeout", l, timeUnit);
            return RealInterceptorChain.copy$okhttp$default(this, 0, null, null, 0, n2, 0, 47, null);
        }
        throw new IllegalStateException("Timeouts can't be adjusted in a network interceptor".toString());
    }

    @Override
    public Interceptor$Chain withWriteTimeout(int n, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)timeUnit, "unit");
        if (this.exchange == null) {
            long l = n;
            int n2 = Util.checkDuration("writeTimeout", l, timeUnit);
            return RealInterceptorChain.copy$okhttp$default(this, 0, null, null, 0, 0, n2, 31, null);
        }
        throw new IllegalStateException("Timeouts can't be adjusted in a network interceptor".toString());
    }

    @Override
    public Call call() {
        return this.call;
    }

    @Override
    public Request request() {
        return this.request;
    }

    @Override
    public Response proceed(Request object) {
        Intrinsics.checkNotNullParameter(object, "request");
        if (((RealInterceptorChain)object2).index < ((RealInterceptorChain)object2).interceptors.size()) {
            Object object2;
            RealInterceptorChain realInterceptorChain = object2;
            ++realInterceptorChain.calls;
            Object object3 = realInterceptorChain.exchange;
            if (object3 != null) {
                if (((Exchange)object3).getFinder$okhttp().sameHostAndPort(((Request)object).url())) {
                    if (!(((RealInterceptorChain)object2).calls == 1)) {
                        object2 = "network interceptor " + ((RealInterceptorChain)object2).interceptors.get(((RealInterceptorChain)object2).index - 1) + " must call proceed() exactly once";
                        throw new IllegalStateException(object2.toString());
                    }
                } else {
                    object2 = "network interceptor " + ((RealInterceptorChain)object2).interceptors.get(((RealInterceptorChain)object2).index - 1) + " must retain the same host and port";
                    throw new IllegalStateException(object2.toString());
                }
            }
            RealInterceptorChain realInterceptorChain2 = object2;
            object = RealInterceptorChain.copy$okhttp$default(realInterceptorChain2, realInterceptorChain2.index + 1, null, (Request)object, 0, 0, 0, 58, null);
            object3 = (Interceptor)realInterceptorChain2.interceptors.get(((RealInterceptorChain)object2).index);
            Response response = object3.intercept((Interceptor$Chain)object);
            if (response != null) {
                if (((RealInterceptorChain)object2).exchange != null) {
                    if (!(((RealInterceptorChain)object2).index + 1 >= ((RealInterceptorChain)object2).interceptors.size() || ((RealInterceptorChain)object).calls == 1)) {
                        object2 = "network interceptor " + object3 + " must call proceed() exactly once";
                        throw new IllegalStateException(object2.toString());
                    }
                }
                if (response.body() != null) {
                    return response;
                }
                object2 = "interceptor " + object3 + " returned a response with no body";
                throw new IllegalStateException(object2.toString());
            }
            throw new NullPointerException("interceptor " + object3 + " returned null");
        }
        throw new IllegalStateException("Check failed.".toString());
    }
}

