/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.Dns;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheInterceptor;
import okhttp3.internal.connection.ConnectInterceptor;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealCall$CallReference;
import okhttp3.internal.connection.RealCall$timeout$1;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.http.BridgeInterceptor;
import okhttp3.internal.http.CallServerInterceptor;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.RetryAndFollowUpInterceptor;
import okhttp3.internal.platform.Platform;

public final class RealCall
implements Call {
    private final OkHttpClient client;
    private final Request originalRequest;
    private final boolean forWebSocket;
    private final RealConnectionPool connectionPool;
    private final EventListener eventListener;
    private final RealCall$timeout$1 timeout;
    private final AtomicBoolean executed;
    private Object callStackTrace;
    private ExchangeFinder exchangeFinder;
    private RealConnection connection;
    private boolean timeoutEarlyExit;
    private Exchange interceptorScopedExchange;
    private boolean requestBodyOpen;
    private boolean responseBodyOpen;
    private boolean expectMoreExchanges;
    private volatile boolean canceled;
    private volatile Exchange exchange;
    private volatile RealConnection connectionToCancel;

    public RealCall(OkHttpClient okHttpClient, Request request, boolean bl) {
        RealCall realCall = this;
        Intrinsics.checkNotNullParameter(okHttpClient, "client");
        Intrinsics.checkNotNullParameter(request, "originalRequest");
        this.client = okHttpClient;
        this.originalRequest = request;
        this.forWebSocket = bl;
        this.connectionPool = okHttpClient.connectionPool().getDelegate$okhttp();
        realCall.eventListener = okHttpClient.eventListenerFactory().create(this);
        RealCall$timeout$1 realCall$timeout$1 = new RealCall$timeout$1(this);
        realCall$timeout$1.timeout(this.getClient().callTimeoutMillis(), TimeUnit.MILLISECONDS);
        realCall.timeout = realCall$timeout$1;
        realCall.executed = new AtomicBoolean();
        realCall.expectMoreExchanges = true;
    }

    private final void callStart() {
        this.callStackTrace = Platform.Companion.get().getStackTraceForCloseable("response.body().close()");
        this.eventListener.callStart(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final IOException callDone(IOException iOException) {
        RealConnection realConnection;
        boolean bl = Util.assertionsEnabled;
        if (bl) {
            if (Thread.holdsLock(this)) throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        if ((realConnection = this.connection) != null) {
            if (bl) {
                if (Thread.holdsLock(realConnection)) throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + realConnection));
            }
            // MONITORENTER : realConnection
            Socket socket = this.releaseConnectionNoEvents$okhttp();
            if (this.connection == null) {
                if (socket != null) {
                    Util.closeQuietly(socket);
                }
                this.eventListener.connectionReleased(this, realConnection);
            } else if (!(socket == null)) throw new IllegalStateException("Check failed.".toString());
        }
        IOException iOException2 = iOException;
        iOException = this.timeoutExit(iOException);
        if (iOException2 != null) {
            Intrinsics.checkNotNull(iOException);
            this.eventListener.callFailed(this, iOException);
            return iOException;
        }
        this.eventListener.callEnd(this);
        return iOException;
    }

    private final IOException timeoutExit(IOException iOException) {
        InterruptedIOException interruptedIOException;
        if (((RealCall)((Object)interruptedIOException2)).timeoutEarlyExit) {
            return iOException;
        }
        if (!((RealCall)((Object)interruptedIOException2)).timeout.exit()) {
            return iOException;
        }
        InterruptedIOException interruptedIOException2 = interruptedIOException;
        interruptedIOException = new InterruptedIOException("timeout");
        if (iOException != null) {
            interruptedIOException2.initCause(iOException);
        }
        return interruptedIOException2;
    }

    private final Address createAddress(HttpUrl object) {
        SSLSocketFactory sSLSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (((HttpUrl)object).isHttps()) {
            RealCall realCall = dns;
            sSLSocketFactory = realCall.client.sslSocketFactory();
            hostnameVerifier = realCall.client.hostnameVerifier();
            certificatePinner = realCall.client.certificatePinner();
        }
        HttpUrl httpUrl = object;
        object = httpUrl.host();
        int n = httpUrl.port();
        Object object2 = object;
        RealCall realCall = dns;
        Dns dns = realCall.client.dns();
        object = realCall.client.socketFactory();
        Authenticator authenticator = realCall.client.proxyAuthenticator();
        Proxy proxy = realCall.client.proxy();
        List list = realCall.client.protocols();
        List list2 = realCall.client.connectionSpecs();
        ProxySelector proxySelector = realCall.client.proxySelector();
        return new Address((String)object2, n, dns, (SocketFactory)object, sSLSocketFactory, hostnameVerifier, certificatePinner, authenticator, proxy, list, list2, proxySelector);
    }

    public final OkHttpClient getClient() {
        return this.client;
    }

    public final EventListener getEventListener$okhttp() {
        return this.eventListener;
    }

    public final RealConnection getConnection() {
        return this.connection;
    }

    public final Exchange getInterceptorScopedExchange$okhttp() {
        return this.interceptorScopedExchange;
    }

    public final void setConnectionToCancel(RealConnection realConnection) {
        this.connectionToCancel = realConnection;
    }

    public RealCall clone() {
        RealCall realCall = cloneable2;
        Cloneable cloneable2 = realCall.client;
        Request request = realCall.originalRequest;
        boolean bl = realCall.forWebSocket;
        return new RealCall((OkHttpClient)cloneable2, request, bl);
    }

    public void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        Object object = this.exchange;
        if (object != null) {
            ((Exchange)object).cancel();
        }
        object = this.connectionToCancel;
        if (object != null) {
            ((RealConnection)object).cancel();
        }
        this.eventListener.canceled(this);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public Response execute() {
        if (this.executed.compareAndSet(false, true)) {
            Response response;
            RealCall realCall = this;
            realCall.timeout.enter();
            realCall.callStart();
            try {
                realCall.client.dispatcher().executed$okhttp(this);
                response = realCall.getResponseWithInterceptorChain$okhttp();
                this.client.dispatcher().finished$okhttp(this);
            }
            catch (Throwable throwable) {
                this.client.dispatcher().finished$okhttp(this);
                throw throwable;
            }
            return response;
        }
        throw new IllegalStateException("Already Executed".toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Response getResponseWithInterceptorChain$okhttp() {
        Throwable throwable;
        boolean bl;
        Object object;
        block9: {
            ArrayList<Interceptor> arrayList;
            ArrayList<Interceptor> arrayList2 = arrayList;
            arrayList2();
            CollectionsKt.addAll(arrayList, this.client.interceptors());
            arrayList.add(new RetryAndFollowUpInterceptor(this.client));
            arrayList.add(new BridgeInterceptor(this.client.cookieJar()));
            this.client.cache();
            arrayList.add(new CacheInterceptor(null));
            arrayList.add(ConnectInterceptor.INSTANCE);
            if (!this.forWebSocket) {
                CollectionsKt.addAll(arrayList2, this.client.networkInterceptors());
            }
            arrayList2.add(new CallServerInterceptor(this.forWebSocket));
            RealCall realCall = this;
            object = realCall.originalRequest;
            int n = realCall.client.connectTimeoutMillis();
            int n2 = realCall.client.readTimeoutMillis();
            int n3 = realCall.client.writeTimeoutMillis();
            bl = false;
            object = new RealInterceptorChain(realCall, arrayList2, 0, null, (Request)object, n, n2, n3).proceed(this.originalRequest);
            if (this.isCanceled()) break block9;
            this.noMoreExchanges$okhttp(null);
            return object;
        }
        try {
            Util.closeQuietly((Closeable)object);
            throw new IOException("Canceled");
        }
        catch (Throwable throwable2) {
        }
        catch (IOException iOException) {
            boolean bl2 = true;
            IOException iOException2 = this.noMoreExchanges$okhttp(iOException);
            if (iOException2 != null) throw iOException2;
            try {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
            }
            catch (Throwable throwable3) {
                bl = bl2;
                throwable = throwable3;
            }
        }
        if (bl) throw throwable;
        this.noMoreExchanges$okhttp(null);
        throw throwable;
    }

    /*
     * Unable to fully structure code
     */
    public final void enterNetworkInterceptorExchange(Request var1_1, boolean var2_2) {
        block10: {
            Intrinsics.checkNotNullParameter(var1_1, "request");
            if (!(this.interceptorScopedExchange == null)) break block10;
            v0 = this;
            synchronized (v0) {
                block9: {
                    if (!(v0.responseBodyOpen ^ true)) ** GOTO lbl30
                    if (!(this.requestBodyOpen ^ true)) break block9;
                    v2 = var2_2;
                    v3 = this;
                    // ** MonitorExit[v3] (shouldn't be in output)
                    if (v2) {
                        v4 = this;
                        v5 = var1_1;
                        var1_1 = this.connectionPool;
                        var2_3 = v4.createAddress(v5.url());
                        var3_4 = v4.eventListener;
                        this.exchangeFinder = new ExchangeFinder((RealConnectionPool)var1_1, var2_3, this, var3_4);
                    }
                    return;
                }
                var1_1 = "Check failed.";
                throw new IllegalStateException(var1_1.toString());
lbl30:
                // 1 sources

                var1_1 = "cannot make a new request because the previous response is still open: please call response.close()";
                throw new IllegalStateException(var1_1.toString());
            }
        }
        throw new IllegalStateException("Check failed.".toString());
    }

    /*
     * Unable to fully structure code
     */
    public final Exchange initExchange$okhttp(RealInterceptorChain var1_1) {
        v0 = this;
        Intrinsics.checkNotNullParameter(var1_1, "chain");
        synchronized (v0) {
            block14: {
                if (!v0.expectMoreExchanges) ** GOTO lbl52
                if (!(this.responseBodyOpen ^ true)) ** GOTO lbl49
                if (!(this.requestBodyOpen ^ true)) break block14;
                v2 = this;
                v3 = v2;
                v4 = v2;
                v5 = v2;
                v6 = v2;
                v7 = v2;
                v8 = v2;
                v9 = v2;
                v10 = v2;
                v11 = v2;
                // ** MonitorExit[v8] (shouldn't be in output)
                var2_2 = v9.exchangeFinder;
                Intrinsics.checkNotNull(var2_2);
                var1_1 = var2_2.find(this.client, (RealInterceptorChain)var1_1);
                var3_3 = v12;
                v13 = this;
                v10.interceptorScopedExchange = new Exchange(v13, v13.eventListener, var2_2, (ExchangeCodec)var1_1);
                v11.exchange = var3_3;
                synchronized (v6) {
                    v7.requestBodyOpen = true;
                    v4.responseBodyOpen = true;
                    if (!v3.canceled) {
                        return var3_3;
                    }
                    throw new IOException("Canceled");
                }
            }
            var1_1 = "Check failed.";
            throw new IllegalStateException(var1_1.toString());
lbl49:
            // 1 sources

            var1_1 = "Check failed.";
            throw new IllegalStateException(var1_1.toString());
lbl52:
            // 1 sources

            var1_1 = "released";
            throw new IllegalStateException(var1_1.toString());
        }
    }

    public final void acquireConnectionNoEvents(RealConnection realConnection) {
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
        }
        if (this.connection == null) {
            this.connection = realConnection;
            RealCall realCall = this;
            realConnection.getCalls().add(new RealCall$CallReference(realCall, realCall.callStackTrace));
            return;
        }
        throw new IllegalStateException("Check failed.".toString());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IOException messageDone$okhttp(Exchange var1_1, boolean var2_4, boolean var3_5, IOException var4_6) {
        Intrinsics.checkNotNullParameter(var1_1, "exchange");
        if (!Intrinsics.areEqual(var1_1, this.exchange)) {
            return var4_6;
        }
        var1_2 = false;
        var5_7 = false;
        synchronized (this) {
            block17: {
                block15: {
                    if (var2_4) {
                        try {
                            if (this.requestBodyOpen) break block15;
                        }
                        catch (Throwable v0) {
                            ** break block16
                        }
                    }
                    if (!var3_5 || !this.responseBodyOpen) break block17;
                }
                if (var2_4) {
                    this.requestBodyOpen = false;
                }
                if (var3_5) {
                    this.responseBodyOpen = false;
                }
                var2_4 = (var1_2 = this.requestBodyOpen) == false && this.responseBodyOpen == false;
                var5_7 = var1_2 == false && this.responseBodyOpen == false && this.expectMoreExchanges == false ? (var1_2 = true) : (var1_2 = false);
                var1_2 = var2_4;
            }
            ** if (!var1_2) goto lbl29
        }
lbl-1000:
        // 1 sources

        {
            this.exchange = null;
            var1_3 = this.connection;
            if (var1_3 != null) {
                var1_3.incrementSuccessCount$okhttp();
            }
        }
lbl29:
        // 4 sources

        if (var5_7) {
            return this.callDone(var4_6);
        }
        return var4_6;
lbl-1000:
        // 1 sources

        {
            throw v0;
        }
    }

    public final IOException noMoreExchanges$okhttp(IOException iOException) {
        RealCall realCall = this;
        boolean bl = false;
        synchronized (realCall) {
            block7: {
                block8: {
                    if (!realCall.expectMoreExchanges) break block7;
                    this.expectMoreExchanges = false;
                    if (this.requestBodyOpen) break block8;
                    if (this.responseBodyOpen) break block8;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            boolean bl2 = bl;
            RealCall realCall2 = this;
            if (bl2) {
                return this.callDone(iOException);
            }
            return iOException;
        }
    }

    public final Socket releaseConnectionNoEvents$okhttp() {
        int n;
        List list;
        RealConnection realConnection;
        block6: {
            realConnection = this.connection;
            Intrinsics.checkNotNull(realConnection);
            if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
            }
            list = realConnection.getCalls();
            n = 0;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                if (!Intrinsics.areEqual(((Reference)iterator2.next()).get(), this)) {
                    ++n;
                    continue;
                }
                break block6;
            }
            n = -1;
        }
        if (n != -1) {
            list.remove(n);
            this.connection = null;
            if (list.isEmpty()) {
                realConnection.setIdleAtNs$okhttp(System.nanoTime());
                if (this.connectionPool.connectionBecameIdle(realConnection)) {
                    return realConnection.socket();
                }
            }
            return null;
        }
        throw new IllegalStateException("Check failed.".toString());
    }

    public final void timeoutEarlyExit() {
        if (this.timeoutEarlyExit ^ true) {
            this.timeoutEarlyExit = true;
            this.timeout.exit();
            return;
        }
        throw new IllegalStateException("Check failed.".toString());
    }

    public final void exitNetworkInterceptorExchange$okhttp(boolean bl) {
        RealCall realCall = this;
        synchronized (realCall) {
            block7: {
                Exchange exchange;
                if (!realCall.expectMoreExchanges) break block7;
                boolean bl2 = bl;
                RealCall realCall2 = this;
                // ** MonitorExit[v3] (shouldn't be in output)
                if (bl2 && (exchange = this.exchange) != null) {
                    exchange.detachWithViolence();
                }
                this.interceptorScopedExchange = null;
                return;
            }
            String string = "released";
            throw new IllegalStateException(string.toString());
        }
    }

    public final boolean retryAfterFailure() {
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        Intrinsics.checkNotNull(exchangeFinder);
        return exchangeFinder.retryAfterFailure();
    }
}

