/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RouteDatabase;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.RouteSelector;
import okhttp3.internal.connection.RouteSelector$Selection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.StreamResetException;

public final class ExchangeFinder {
    private final RealConnectionPool connectionPool;
    private final Address address;
    private final RealCall call;
    private final EventListener eventListener;
    private RouteSelector$Selection routeSelection;
    private RouteSelector routeSelector;
    private int refusedStreamCount;
    private int connectionShutdownCount;
    private int otherFailureCount;
    private Route nextRouteToTry;

    public ExchangeFinder(RealConnectionPool realConnectionPool, Address address, RealCall realCall, EventListener eventListener) {
        Intrinsics.checkNotNullParameter(realConnectionPool, "connectionPool");
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(realCall, "call");
        Intrinsics.checkNotNullParameter(eventListener, "eventListener");
        this.connectionPool = realConnectionPool;
        this.address = address;
        this.call = realCall;
        this.eventListener = eventListener;
    }

    private final RealConnection findHealthyConnection(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        Object object;
        do {
            if (((RealConnection)(object = this.findConnection(n, n2, n3, n4, bl))).isHealthy(bl2)) {
                return object;
            }
            ((RealConnection)object).noNewExchanges$okhttp();
        } while (this.nextRouteToTry != null || ((object = this.routeSelection) == null ? true : ((RouteSelector$Selection)object).hasNext()) || ((object = this.routeSelector) == null ? true : ((RouteSelector)object).hasNext()));
        throw new IOException("exhausted all routes");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final RealConnection findConnection(int var1_1, int var2_5, int var3_7, int var4_8, boolean var5_9) {
        block18: {
            block20: {
                block19: {
                    if (this.call.isCanceled() != false) throw new IOException("Canceled");
                    var6_10 = this.call.getConnection();
                    if (var6_10 != null) {
                        v0 = var6_10;
                        var7_11 = null;
                        // MONITORENTER : v0
                        if (v0.getNoNewExchanges() || !this.sameHostAndPort(var6_10.route().address().url())) {
                            var7_11 = this.call.releaseConnectionNoEvents$okhttp();
                        }
                        v1 = this;
                        v2 = var6_10;
                        if (v1.call.getConnection() != null) {
                            if (var7_11 == null == false) throw new IllegalStateException("Check failed.".toString());
                            return var6_10;
                        }
                        if (var7_11 != null) {
                            Util.closeQuietly((Socket)var7_11);
                        }
                        this.eventListener.connectionReleased(this.call, (Connection)var6_10);
                    }
                    this.refusedStreamCount = 0;
                    this.connectionShutdownCount = 0;
                    this.otherFailureCount = 0;
                    v4 = this;
                    var6_10 = v4.address;
                    if (this.connectionPool.callAcquirePooledConnection((Address)var6_10, v4.call, null, false)) {
                        var1_2 = this.call.getConnection();
                        Intrinsics.checkNotNull(var1_2);
                        this.eventListener.connectionAcquired(this.call, var1_2);
                        return var1_2;
                    }
                    var6_10 = this.nextRouteToTry;
                    if (var6_10 == null) break block19;
                    var7_11 = null;
                    Intrinsics.checkNotNull(var6_10);
                    this.nextRouteToTry = null;
                    break block20;
                }
                var6_10 = this.routeSelection;
                if (var6_10 == null) ** GOTO lbl-1000
                v5 = var6_10;
                Intrinsics.checkNotNull(v5);
                if (v5.hasNext()) {
                    var7_11 = null;
                    v6 = this.routeSelection;
                    Intrinsics.checkNotNull(v6);
                    var6_10 = v6.next();
                } else lbl-1000:
                // 2 sources

                {
                    if ((var6_10 = this.routeSelector) == null) {
                        var6_10 = v7;
                        v8 = this;
                        var7_11 = v8.address;
                        var8_12 = v8.call.getClient().getRouteDatabase();
                        var9_13 = v8.call;
                        var10_14 = v8.eventListener;
                        this.routeSelector = new RouteSelector((Address)var7_11, (RouteDatabase)var8_12, var9_13, var10_14);
                    }
                    this.routeSelection = var6_10 = var6_10.next();
                    var7_11 = var6_10.getRoutes();
                    if (this.call.isCanceled() != false) throw new IOException("Canceled");
                    v9 = this;
                    var8_12 = v9.address;
                    if (this.connectionPool.callAcquirePooledConnection((Address)var8_12, v9.call, (List)var7_11, false)) {
                        var1_3 = this.call.getConnection();
                        Intrinsics.checkNotNull(var1_3);
                        this.eventListener.connectionAcquired(this.call, var1_3);
                        return var1_3;
                    }
                    var6_10 = var6_10.next();
                }
            }
            v10 = this;
            var8_12 = v11;
            v12 = this;
            var8_12(this.connectionPool, (Route)var6_10);
            v12.call.setConnectionToCancel((RealConnection)var8_12);
            try {
                var1_4 = v12.call;
                var2_6 = v12.eventListener;
                v11.connect(var1_1, var2_5, var3_7, var4_8, var5_9, (Call)var1_4, var2_6);
                v10.call.setConnectionToCancel(null);
                v10.call.getClient().getRouteDatabase().connected(var8_12.route());
                v13 = this;
                var1_4 = v13.address;
                if (!v10.connectionPool.callAcquirePooledConnection((Address)var1_4, v13.call, (List)var7_11, true)) break block18;
                var1_4 = this.call.getConnection();
            }
            catch (Throwable v14) {
                this.call.setConnectionToCancel(null);
                throw v14;
            }
            Intrinsics.checkNotNull(var1_4);
            this.nextRouteToTry = var6_10;
            Util.closeQuietly(var8_12.socket());
            this.eventListener.connectionAcquired(this.call, (Connection)var1_4);
            return var1_4;
        }
        v15 = this;
        // MONITORENTER : var8_12
        v15.connectionPool.put((RealConnection)var8_12);
        v15.call.acquireConnectionNoEvents((RealConnection)var8_12);
        this.eventListener.connectionAcquired(this.call, (Connection)var8_12);
        return var8_12;
    }

    private final Route retryRoute() {
        if (this.refusedStreamCount <= 1 && this.connectionShutdownCount <= 1 && this.otherFailureCount <= 0) {
            RealConnection realConnection = this.call.getConnection();
            if (realConnection == null) {
                return null;
            }
            RealConnection realConnection2 = realConnection;
            synchronized (realConnection2) {
                block8: {
                    block7: {
                        if (realConnection2.getRouteFailureCount$okhttp() == 0) break block7;
                        return null;
                    }
                    if (Util.canReuseConnectionFor(realConnection.route().address().url(), this.getAddress$okhttp().url())) break block8;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return realConnection.route();
            }
        }
        return null;
    }

    public final Address getAddress$okhttp() {
        return this.address;
    }

    public final ExchangeCodec find(OkHttpClient okHttpClient, RealInterceptorChain realInterceptorChain) {
        OkHttpClient okHttpClient2 = okHttpClient;
        RealInterceptorChain realInterceptorChain2 = realInterceptorChain;
        Intrinsics.checkNotNullParameter(okHttpClient, "client");
        Intrinsics.checkNotNullParameter(realInterceptorChain2, "chain");
        int n = realInterceptorChain2.getConnectTimeoutMillis$okhttp();
        int n2 = realInterceptorChain2.getReadTimeoutMillis$okhttp();
        int n3 = realInterceptorChain2.getWriteTimeoutMillis$okhttp();
        int n4 = okHttpClient2.pingIntervalMillis();
        boolean bl = okHttpClient2.retryOnConnectionFailure();
        boolean bl2 = !Intrinsics.areEqual(realInterceptorChain.getRequest$okhttp().method(), "GET");
        try {
            return this.findHealthyConnection(n, n2, n3, n4, bl, bl2).newCodec$okhttp(okHttpClient, realInterceptorChain);
        }
        catch (IOException iOException) {
            this.trackFailure(iOException);
            throw new RouteException(iOException);
        }
        catch (RouteException routeException) {
            this.trackFailure(routeException.getLastConnectException());
            throw routeException;
        }
    }

    public final void trackFailure(IOException iOException) {
        Intrinsics.checkNotNullParameter(iOException, "e");
        this.nextRouteToTry = null;
        if (iOException instanceof StreamResetException && ((StreamResetException)iOException).errorCode == ErrorCode.REFUSED_STREAM) {
            ++this.refusedStreamCount;
        } else if (iOException instanceof ConnectionShutdownException) {
            ++this.connectionShutdownCount;
        } else {
            ++this.otherFailureCount;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean retryAfterFailure() {
        if (((ExchangeFinder)((Object)routeSelector)).refusedStreamCount == 0 && ((ExchangeFinder)((Object)routeSelector)).connectionShutdownCount == 0 && ((ExchangeFinder)((Object)routeSelector)).otherFailureCount == 0) {
            return false;
        }
        if (((ExchangeFinder)((Object)routeSelector)).nextRouteToTry != null) {
            return true;
        }
        Object object = ((ExchangeFinder)((Object)routeSelector)).retryRoute();
        if (object != null) {
            ((ExchangeFinder)((Object)routeSelector)).nextRouteToTry = object;
            return true;
        }
        object = ((ExchangeFinder)((Object)routeSelector)).routeSelection;
        if (object != null && ((RouteSelector$Selection)object).hasNext()) {
            return true;
        }
        boolean bl = false;
        if (bl) {
            return true;
        }
        RouteSelector routeSelector = ((ExchangeFinder)((Object)routeSelector)).routeSelector;
        if (routeSelector != null) return routeSelector.hasNext();
        return true;
    }

    public final boolean sameHostAndPort(HttpUrl httpUrl) {
        Intrinsics.checkNotNullParameter(httpUrl, "url");
        HttpUrl httpUrl2 = ((ExchangeFinder)((Object)httpUrl2)).address.url();
        return httpUrl.port() == httpUrl2.port() && Intrinsics.areEqual(httpUrl.host(), httpUrl2.host());
    }
}

