/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner$Backend;
import okhttp3.internal.concurrent.TaskRunner$Companion;
import okhttp3.internal.concurrent.TaskRunner$RealBackend;
import okhttp3.internal.concurrent.TaskRunner$runnable$1;

public final class TaskRunner {
    public static final TaskRunner$Companion Companion = new TaskRunner$Companion(null);
    public static final TaskRunner INSTANCE = new TaskRunner(new TaskRunner$RealBackend(Util.threadFactory(Intrinsics.stringPlus(Util.okHttpName, " TaskRunner"), true)));
    private static final Logger logger;
    private final TaskRunner$Backend backend;
    private int nextQueueName;
    private boolean coordinatorWaiting;
    private long coordinatorWakeUpAt;
    private final List busyQueues;
    private final List readyQueues;
    private final Runnable runnable;

    public TaskRunner(TaskRunner$Backend object) {
        TaskRunner$runnable$1 taskRunner$runnable$1;
        ArrayList arrayList;
        ArrayList arrayList2;
        Intrinsics.checkNotNullParameter(object, "backend");
        this.backend = object;
        this.nextQueueName = 10000;
        object = arrayList2;
        arrayList2 = new ArrayList();
        this.busyQueues = object;
        object = arrayList;
        arrayList = new ArrayList();
        this.readyQueues = object;
        object = taskRunner$runnable$1;
        taskRunner$runnable$1 = new TaskRunner$runnable$1(this);
        this.runnable = object;
    }

    private final void beforeRun(Task task) {
        TaskQueue taskQueue;
        if (Util.assertionsEnabled && !Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + this));
        }
        Task task2 = task;
        task2.setNextExecuteNanoTime$okhttp(-1L);
        TaskQueue taskQueue2 = taskQueue = task2.getQueue$okhttp();
        Intrinsics.checkNotNull(taskQueue2);
        taskQueue2.getFutureTasks$okhttp().remove(task);
        this.readyQueues.remove(taskQueue);
        taskQueue.setActiveTask$okhttp(task);
        this.busyQueues.add(taskQueue);
    }

    private final void runTask(Task task) {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        Thread thread = Thread.currentThread();
        TaskRunner taskRunner = this;
        String string = thread.getName();
        thread.setName(task.getName());
        long l = -1L;
        try {
            l = task.runOnce();
        }
        catch (Throwable throwable) {
            TaskRunner taskRunner2 = this;
            synchronized (this) {
                taskRunner2.afterRun(task, l);
                thread.setName(string);
                throw throwable;
            }
        }
        synchronized (this) {
            taskRunner.afterRun(task, l);
            thread.setName(string);
            return;
        }
    }

    private final void afterRun(Task task, long l) {
        if (Util.assertionsEnabled && !Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + this));
        }
        TaskQueue taskQueue = task.getQueue$okhttp();
        Intrinsics.checkNotNull(taskQueue);
        if (taskQueue.getActiveTask$okhttp() == task) {
            TaskQueue taskQueue2 = taskQueue;
            boolean bl = taskQueue2.getCancelActiveTask$okhttp();
            taskQueue2.setCancelActiveTask$okhttp(false);
            taskQueue2.setActiveTask$okhttp(null);
            this.busyQueues.remove(taskQueue);
            if (l != -1L && !bl && !taskQueue.getShutdown$okhttp()) {
                taskQueue.scheduleAndDecide$okhttp(task, l, true);
            }
            if (taskQueue.getFutureTasks$okhttp().isEmpty() ^ true) {
                this.readyQueues.add(taskQueue);
            }
            return;
        }
        throw new IllegalStateException("Check failed.".toString());
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$runTask(TaskRunner taskRunner, Task task) {
        taskRunner.runTask(task);
    }

    static {
        Logger logger = Logger.getLogger(TaskRunner.class.getName());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(TaskRunner::class.java.name)");
        TaskRunner.logger = logger;
    }

    public final TaskRunner$Backend getBackend() {
        return this.backend;
    }

    public final void kickCoordinator$okhttp(TaskQueue taskQueue) {
        Intrinsics.checkNotNullParameter(taskQueue, "taskQueue");
        if (Util.assertionsEnabled && !Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + this));
        }
        if (taskQueue.getActiveTask$okhttp() == null) {
            if (taskQueue.getFutureTasks$okhttp().isEmpty() ^ true) {
                Util.addIfAbsent(this.readyQueues, taskQueue);
            } else {
                this.readyQueues.remove(taskQueue);
            }
        }
        if (this.coordinatorWaiting) {
            this.backend.coordinatorNotify(this);
        } else {
            this.backend.execute(this.runnable);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Task awaitTaskToRun() {
        if (Util.assertionsEnabled && !Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + this));
        }
        block4: while (true) {
            if (this.readyQueues.isEmpty()) {
                return null;
            }
            v0 = this;
            var1_1 = v0.backend.nanoTime();
            var3_2 = 0x7FFFFFFFFFFFFFFFL;
            var5_3 = null;
            var6_4 = false;
            var7_5 = v0.readyQueues.iterator();
            while (var7_5.hasNext()) {
                var8_6 = (Task)((TaskQueue)var7_5.next()).getFutureTasks$okhttp().get(0);
                var9_7 = var8_6.getNextExecuteNanoTime$okhttp() - var1_1;
                if ((var9_7 = Math.max(0L, var9_7)) > 0L) {
                    var3_2 = Math.min(var9_7, var3_2);
                    continue;
                }
                if (var5_3 != null) {
                    var6_4 = true;
                    break;
                }
                var5_3 = var8_6;
            }
            if (var5_3 != null) {
                this.beforeRun(var5_3);
                if (var6_4 || !this.coordinatorWaiting && this.readyQueues.isEmpty() ^ true) {
                    this.backend.execute(this.runnable);
                }
                return var5_3;
            }
            if (this.coordinatorWaiting) {
                if (var3_2 < this.coordinatorWakeUpAt - var1_1) {
                    this.backend.coordinatorNotify(this);
                }
                return null;
            }
            v1 = this;
            v2 = v1;
            this.coordinatorWaiting = true;
            v1.coordinatorWakeUpAt = var1_1 + var3_2;
            v1.backend.coordinatorWait(this, var3_2);
lbl38:
            // 2 sources

            while (true) {
                v2.coordinatorWaiting = false;
                continue block4;
                break;
            }
            {
                catch (Throwable v3) {
                    break;
                }
                catch (InterruptedException v4) {}
                {
                    v5 = this;
                    v2 = v5;
                    v5.cancelAll();
                    ** continue;
                }
            }
        }
        this.coordinatorWaiting = false;
        throw v3;
    }

    public final TaskQueue newQueue() {
        TaskRunner taskRunner = this;
        synchronized (taskRunner) {
            int n = taskRunner.nextQueueName;
            taskRunner.nextQueueName = n + 1;
            return new TaskQueue(this, Intrinsics.stringPlus("Q", n));
        }
    }

    public final void cancelAll() {
        int n;
        int n2 = this.busyQueues.size() - 1;
        if (n2 >= 0) {
            while (true) {
                n = n2 + -1;
                ((TaskQueue)this.busyQueues.get(n2)).cancelAllAndDecide$okhttp();
                if (n < 0) break;
                n2 = n;
            }
        }
        if ((n2 = this.readyQueues.size() - 1) >= 0) {
            while (true) {
                n = n2 + -1;
                TaskQueue taskQueue = (TaskQueue)this.readyQueues.get(n2);
                taskQueue.cancelAllAndDecide$okhttp();
                if (taskQueue.getFutureTasks$okhttp().isEmpty()) {
                    this.readyQueues.remove(n2);
                }
                if (n < 0) break;
                n2 = n;
            }
        }
    }
}

