/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.concurrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskLoggerKt;
import okhttp3.internal.concurrent.TaskRunner;

public final class TaskQueue {
    private final TaskRunner taskRunner;
    private final String name;
    private boolean shutdown;
    private Task activeTask;
    private final List futureTasks;
    private boolean cancelActiveTask;

    public TaskQueue(TaskRunner taskRunner, String string) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        Intrinsics.checkNotNullParameter(string, "name");
        ((TaskQueue)((Object)arrayList2)).taskRunner = taskRunner;
        ((TaskQueue)((Object)arrayList2)).name = string;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        v1.futureTasks = arrayList2;
    }

    public static /* synthetic */ void schedule$default(TaskQueue taskQueue, Task task, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        taskQueue.schedule(task, l);
    }

    public final TaskRunner getTaskRunner$okhttp() {
        return this.taskRunner;
    }

    public final String getName$okhttp() {
        return this.name;
    }

    public final boolean getShutdown$okhttp() {
        return this.shutdown;
    }

    public final void setShutdown$okhttp(boolean bl) {
        this.shutdown = bl;
    }

    public final Task getActiveTask$okhttp() {
        return this.activeTask;
    }

    public final void setActiveTask$okhttp(Task task) {
        this.activeTask = task;
    }

    public final List getFutureTasks$okhttp() {
        return this.futureTasks;
    }

    public final boolean getCancelActiveTask$okhttp() {
        return this.cancelActiveTask;
    }

    public final void setCancelActiveTask$okhttp(boolean bl) {
        this.cancelActiveTask = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void schedule(Task task, long l) {
        TaskQueue taskQueue = this;
        Intrinsics.checkNotNullParameter(task, "task");
        TaskRunner taskRunner = taskQueue.taskRunner;
        synchronized (taskRunner) {
            if (taskQueue.getShutdown$okhttp()) {
                if (task.getCancelable()) {
                    if (TaskRunner.Companion.getLogger().isLoggable(Level.FINE)) {
                        TaskLoggerKt.access$log(task, this, "schedule canceled (queue is shutdown)");
                    }
                    return;
                }
                if (TaskRunner.Companion.getLogger().isLoggable(Level.FINE)) {
                    TaskLoggerKt.access$log(task, this, "schedule failed (queue is shutdown)");
                }
                throw new RejectedExecutionException();
            }
            if (this.scheduleAndDecide$okhttp(task, l, false)) {
                this.getTaskRunner$okhttp().kickCoordinator$okhttp(this);
            }
            TaskRunner taskRunner2 = taskRunner;
            return;
        }
    }

    public final boolean scheduleAndDecide$okhttp(Task task, long l, boolean n) {
        block7: {
            TaskQueue taskQueue = this;
            Intrinsics.checkNotNullParameter(task, "task");
            task.initQueue$okhttp(this);
            long l2 = taskQueue.taskRunner.getBackend().nanoTime();
            long l3 = l2 + l;
            int n2 = taskQueue.futureTasks.indexOf(task);
            if (n2 != -1) {
                if (task.getNextExecuteNanoTime$okhttp() <= l3) {
                    if (TaskRunner.Companion.getLogger().isLoggable(Level.FINE)) {
                        TaskLoggerKt.access$log(task, this, "already scheduled");
                    }
                    return false;
                }
                this.futureTasks.remove(n2);
            }
            task.setNextExecuteNanoTime$okhttp(l3);
            if (TaskRunner.Companion.getLogger().isLoggable(Level.FINE)) {
                String string = n != 0 ? Intrinsics.stringPlus("run again after ", TaskLoggerKt.formatDuration(l3 - l2)) : Intrinsics.stringPlus("scheduled after ", TaskLoggerKt.formatDuration(l3 - l2));
                TaskLoggerKt.access$log(task, this, string);
            }
            n = 0;
            Iterator iterator2 = this.futureTasks.iterator();
            while (iterator2.hasNext()) {
                if (!(((Task)iterator2.next()).getNextExecuteNanoTime$okhttp() - l2 > l)) {
                    ++n;
                    continue;
                }
                break block7;
            }
            n = -1;
        }
        if (n == -1) {
            n = this.futureTasks.size();
        }
        this.futureTasks.add(n, task);
        return n == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void cancelAll() {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        TaskQueue taskQueue = this;
        TaskRunner taskRunner = taskQueue.taskRunner;
        synchronized (taskRunner) {
            if (taskQueue.cancelAllAndDecide$okhttp()) {
                this.getTaskRunner$okhttp().kickCoordinator$okhttp(this);
            }
            TaskRunner taskRunner2 = taskRunner;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void shutdown() {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        TaskQueue taskQueue = this;
        TaskRunner taskRunner = taskQueue.taskRunner;
        synchronized (taskRunner) {
            taskQueue.setShutdown$okhttp(true);
            if (taskQueue.cancelAllAndDecide$okhttp()) {
                this.getTaskRunner$okhttp().kickCoordinator$okhttp(this);
            }
            TaskRunner taskRunner2 = taskRunner;
            return;
        }
    }

    public final boolean cancelAllAndDecide$okhttp() {
        Task task = this.activeTask;
        if (task != null) {
            Task task2 = task;
            Intrinsics.checkNotNull(task2);
            if (task2.getCancelable()) {
                this.cancelActiveTask = true;
            }
        }
        boolean bl = false;
        int n = this.futureTasks.size() - 1;
        if (n >= 0) {
            while (true) {
                int n2 = n + -1;
                if (((Task)this.futureTasks.get(n)).getCancelable()) {
                    Task task3 = (Task)this.futureTasks.get(n);
                    if (TaskRunner.Companion.getLogger().isLoggable(Level.FINE)) {
                        TaskLoggerKt.access$log(task3, this, "canceled");
                    }
                    bl = true;
                    this.futureTasks.remove(n);
                }
                if (n2 < 0) break;
                n = n2;
            }
        }
        return bl;
    }

    public String toString() {
        return this.name;
    }
}

