/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.net.IDN;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Locale;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okio.Buffer;

public abstract class HostnamesKt {
    public static final String toCanonicalHost(String string) {
        block11: {
            String string2 = string;
            Intrinsics.checkNotNullParameter(string2, "<this>");
            if (StringsKt.contains$default((CharSequence)string2, ":", false, 2, null)) {
                InetAddress inetAddress;
                if (StringsKt.startsWith$default(string, "[", false, 2, null) && StringsKt.endsWith$default(string, "]", false, 2, null)) {
                    String string3 = string;
                    inetAddress = HostnamesKt.decodeIpv6(string3, 1, string3.length() - 1);
                } else {
                    String string4 = string;
                    inetAddress = HostnamesKt.decodeIpv6(string4, 0, string4.length());
                }
                if (inetAddress == null) {
                    return null;
                }
                byte[] byArray = inetAddress.getAddress();
                if (byArray.length == 16) {
                    Intrinsics.checkNotNullExpressionValue(byArray, "address");
                    return HostnamesKt.inet6AddressToAscii(byArray);
                }
                if (byArray.length == 4) {
                    return inetAddress.getHostAddress();
                }
                throw new AssertionError((Object)("Invalid IPv6 address: '" + string + '\''));
            }
            try {
                String string5 = IDN.toASCII(string);
                Intrinsics.checkNotNullExpressionValue(string5, "toASCII(host)");
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue(locale, "US");
                string = string5.toLowerCase(locale);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(locale)");
            if (!(string.length() == 0)) break block11;
            return null;
        }
        if (HostnamesKt.containsInvalidHostnameAsciiCodes(string)) {
            string = null;
        }
        return string;
    }

    private static final boolean containsInvalidHostnameAsciiCodes(String string) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c;
            if (Intrinsics.compare(c = string.charAt(n++), 31) > 0 && Intrinsics.compare(c, 127) < 0) {
                if (StringsKt.indexOf$default((CharSequence)" #%/:?@[\\]", c, 0, false, 6, null) == -1) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final InetAddress decodeIpv6(String string, int n, int n2) {
        int n3 = 16;
        byte[] byArray = new byte[16];
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        while (n < n2) {
            int n7;
            int n8;
            block13: {
                if (n4 == n3) {
                    return null;
                }
                n8 = n + 2;
                if (n8 <= n2 && StringsKt.startsWith$default(string, "::", n, false, 4, null)) {
                    if (n5 != -1) {
                        return null;
                    }
                    n5 = n4 + 2;
                    if (n8 == n2) {
                        n4 = n5;
                        break;
                    }
                    n4 = n5;
                    n6 = n8;
                } else {
                    if (n4 != 0) {
                        if (StringsKt.startsWith$default(string, ":", n, false, 4, null)) {
                            n6 = ++n;
                            break block13;
                        } else {
                            if (!StringsKt.startsWith$default(string, ".", n, false, 4, null)) return null;
                            int n9 = n4 - 2;
                            if (!HostnamesKt.decodeIpv4Suffix(string, n6, n2, byArray, n9)) {
                                return null;
                            }
                            n4 += 2;
                            break;
                        }
                    }
                    n6 = n;
                }
            }
            n8 = n = 0;
            for (n = n6; n < n2 && (n7 = Util.parseHexDigit(string.charAt(n))) != -1; ++n) {
                n8 = (n8 << 4) + n7;
            }
            n7 = n - n6;
            if (n7 == 0) return null;
            if (n7 > 4) {
                return null;
            }
            int n10 = n8;
            byArray[n4++] = (byte)(n8 >>> 8 & 0xFF);
            n8 = n4 + 1;
            byArray[n4] = (byte)(n10 & 0xFF);
            n4 = n8;
        }
        if (n4 == n3) return InetAddress.getByAddress(byArray);
        if (n5 == -1) {
            return null;
        }
        int n11 = n5;
        int n12 = n4 - n5;
        System.arraycopy(byArray, n5, byArray, n3 - n12, n12);
        Arrays.fill(byArray, n11, n11 + (n3 - n4), (byte)0);
        return InetAddress.getByAddress(byArray);
    }

    private static final boolean decodeIpv4Suffix(String string, int n, int n2, byte[] byArray, int n3) {
        int n4 = n3;
        while (n < n2) {
            char c;
            int n5;
            if (n4 == byArray.length) {
                return false;
            }
            if (n4 != n3 && string.charAt(n) != '.') {
                return false;
            }
            int n6 = n5 = 0;
            for (n5 = ++n; n5 < n2 && Intrinsics.compare(c = string.charAt(n5), 48) >= 0 && Intrinsics.compare(c, 57) <= 0; ++n5) {
                if (n6 == 0 && n != n5) {
                    return false;
                }
                if ((n6 = n6 * 10 + c - 48) <= 255) continue;
                return false;
            }
            if (n5 - n == 0) {
                return false;
            }
            n = n4 + 1;
            byArray[n4] = (byte)n6;
            n4 = n;
            n = n5;
        }
        return n4 == n3 + 4;
    }

    private static final String inet6AddressToAscii(byte[] byArray) {
        Buffer buffer;
        int n;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            for (n = n4; n < 16 && byArray[n] == 0 && byArray[n + 1] == 0; n += 2) {
            }
            int n5 = n - n4;
            if (n5 > n3 && n5 >= 4) {
                n3 = n5;
                n2 = n4;
            }
            n4 = n + 2;
        }
        Buffer buffer2 = buffer;
        buffer = new Buffer();
        n = 0;
        while (n < byArray.length) {
            if (n == n2) {
                buffer2.writeByte(58);
                if ((n += n3) != 16) continue;
                buffer2.writeByte(58);
                continue;
            }
            if (n > 0) {
                buffer2.writeByte(58);
            }
            buffer2.writeHexadecimalUnsignedLong(Util.and(byArray[n], 255) << 8 | Util.and(byArray[n + 1], 255));
            n += 2;
        }
        return buffer2.readUtf8();
    }
}

