/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request$Builder;
import okhttp3.RequestBody;

public final class Request {
    private final HttpUrl url;
    private final String method;
    private final Headers headers;
    private final RequestBody body;
    private final Map tags;
    private CacheControl lazyCacheControl;

    public Request(HttpUrl httpUrl, String string, Headers headers, RequestBody requestBody, Map map) {
        Intrinsics.checkNotNullParameter(httpUrl, "url");
        Intrinsics.checkNotNullParameter(string, "method");
        Intrinsics.checkNotNullParameter(headers, "headers");
        Intrinsics.checkNotNullParameter(map, "tags");
        this.url = httpUrl;
        this.method = string;
        this.headers = headers;
        this.body = requestBody;
        this.tags = map;
    }

    public final HttpUrl url() {
        return this.url;
    }

    public final String method() {
        return this.method;
    }

    public final Headers headers() {
        return this.headers;
    }

    public final RequestBody body() {
        return this.body;
    }

    public final Map getTags$okhttp() {
        return this.tags;
    }

    public final boolean isHttps() {
        return this.url.isHttps();
    }

    public final String header(String string) {
        Intrinsics.checkNotNullParameter(string, "name");
        return this.headers.get(string);
    }

    public final Request$Builder newBuilder() {
        return new Request$Builder(this);
    }

    public final CacheControl cacheControl() {
        CacheControl cacheControl = this.lazyCacheControl;
        if (cacheControl == null) {
            this.lazyCacheControl = cacheControl = CacheControl.Companion.parse(this.headers);
        }
        return cacheControl;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = stringBuilder2 = stringBuilder;
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder4();
        stringBuilder4.append("Request{method=");
        stringBuilder3.append(this.method());
        stringBuilder3.append(", url=");
        stringBuilder.append(this.url());
        if (this.headers().size() != 0) {
            stringBuilder2.append(", headers=[");
            int n = 0;
            for (Object object : this.headers()) {
                int n2 = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)object;
                String string = (String)pair.component1();
                object = (String)pair.component2();
                if (n > 0) {
                    stringBuilder2.append(", ");
                }
                StringBuilder stringBuilder5 = stringBuilder2;
                stringBuilder5.append(string);
                stringBuilder5.append(':');
                stringBuilder5.append((String)object);
                n = n2;
            }
            stringBuilder2.append(']');
        }
        if (this.getTags$okhttp().isEmpty() ^ true) {
            stringBuilder2.append(", tags=");
            stringBuilder2.append(this.getTags$okhttp());
        }
        StringBuilder stringBuilder6 = stringBuilder2;
        stringBuilder6.append('}');
        String string = stringBuilder6.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

