/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.HttpUrl$Builder$Companion;
import okhttp3.HttpUrl$Companion;
import okhttp3.internal.HostnamesKt;
import okhttp3.internal.Util;

public final class HttpUrl$Builder {
    public static final HttpUrl$Builder$Companion Companion = new HttpUrl$Builder$Companion(null);
    private String scheme;
    private String encodedUsername = "";
    private String encodedPassword = "";
    private String host;
    private int port = -1;
    private final List encodedPathSegments;
    private List encodedQueryNamesAndValues;
    private String encodedFragment;

    public HttpUrl$Builder() {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList2();
        this.encodedPathSegments = arrayList2;
        arrayList.add("");
    }

    private final int effectivePort() {
        int n = this.port;
        if (n == -1) {
            String string = this.scheme;
            Intrinsics.checkNotNull(string);
            n = HttpUrl.Companion.defaultPort(string);
        }
        return n;
    }

    private final HttpUrl$Builder addPathSegments(String string, boolean bl) {
        int n;
        int n2 = 0;
        do {
            String string2 = string;
            n = string2.length();
            boolean bl2 = (n = Util.delimiterOffset(string2, "/\\", n2, n)) < string.length();
            this.push(string, n2, n, bl2, bl);
        } while ((n2 = n + 1) <= string.length());
        return this;
    }

    private final void resolvePath(String string, int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = string.charAt(n);
        if (n3 != 47 && n3 != 92) {
            List list = this.encodedPathSegments;
            list.set(list.size() - 1, "");
        } else {
            HttpUrl$Builder httpUrl$Builder = this;
            httpUrl$Builder.encodedPathSegments.clear();
            httpUrl$Builder.encodedPathSegments.add("");
            ++n;
        }
        while (n < n2) {
            n3 = Util.delimiterOffset(string, "/\\", n, n2);
            boolean bl = n3 < n2;
            this.push(string, n, n3, bl, true);
            if (bl) {
                n = n3 + 1;
                continue;
            }
            n = n3;
        }
    }

    private final void push(String string, int n, int n2, boolean bl, boolean bl2) {
        if (this.isDot(string = HttpUrl$Companion.canonicalize$okhttp$default(HttpUrl.Companion, string, n, n2, " \"<>^`{}|/\\?#", bl2, false, false, false, null, 240, null))) {
            return;
        }
        if (this.isDotDot(string)) {
            this.pop();
            return;
        }
        List list = this.encodedPathSegments;
        if (((CharSequence)list.get(list.size() - 1)).length() == 0) {
            List list2 = this.encodedPathSegments;
            list2.set(list2.size() - 1, string);
        } else {
            this.encodedPathSegments.add(string);
        }
        if (bl) {
            this.encodedPathSegments.add("");
        }
    }

    private final boolean isDot(String string) {
        return Intrinsics.areEqual(string, ".") || StringsKt.equals(string, "%2e", true);
    }

    private final boolean isDotDot(String string) {
        return Intrinsics.areEqual(string, "..") || StringsKt.equals(string, "%2e.", true) || StringsKt.equals(string, ".%2e", true) || StringsKt.equals(string, "%2e%2e", true);
    }

    private final void pop() {
        List list = this.encodedPathSegments;
        if (((String)list.remove(list.size() - 1)).length() == 0 && this.encodedPathSegments.isEmpty() ^ true) {
            List list2 = this.encodedPathSegments;
            list2.set(list2.size() - 1, "");
        } else {
            this.encodedPathSegments.add("");
        }
    }

    public final String getScheme$okhttp() {
        return this.scheme;
    }

    public final void setScheme$okhttp(String string) {
        this.scheme = string;
    }

    public final String getEncodedUsername$okhttp() {
        return this.encodedUsername;
    }

    public final void setEncodedUsername$okhttp(String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.encodedUsername = string;
    }

    public final String getEncodedPassword$okhttp() {
        return this.encodedPassword;
    }

    public final void setEncodedPassword$okhttp(String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.encodedPassword = string;
    }

    public final String getHost$okhttp() {
        return this.host;
    }

    public final void setHost$okhttp(String string) {
        this.host = string;
    }

    public final int getPort$okhttp() {
        return this.port;
    }

    public final void setPort$okhttp(int n) {
        this.port = n;
    }

    public final List getEncodedPathSegments$okhttp() {
        return this.encodedPathSegments;
    }

    public final List getEncodedQueryNamesAndValues$okhttp() {
        return this.encodedQueryNamesAndValues;
    }

    public final void setEncodedQueryNamesAndValues$okhttp(List list) {
        this.encodedQueryNamesAndValues = list;
    }

    public final String getEncodedFragment$okhttp() {
        return this.encodedFragment;
    }

    public final void setEncodedFragment$okhttp(String string) {
        this.encodedFragment = string;
    }

    public final HttpUrl$Builder scheme(String string) {
        block4: {
            block3: {
                block2: {
                    String string2 = string;
                    Intrinsics.checkNotNullParameter(string2, "scheme");
                    if (!StringsKt.equals(string2, "http", true)) break block2;
                    this.setScheme$okhttp("http");
                    break block3;
                }
                if (!StringsKt.equals(string, "https", true)) break block4;
                this.setScheme$okhttp("https");
            }
            return this;
        }
        throw new IllegalArgumentException(Intrinsics.stringPlus("unexpected scheme: ", string));
    }

    public final HttpUrl$Builder username(String string) {
        HttpUrl$Builder httpUrl$Builder = this;
        Intrinsics.checkNotNullParameter(string, "username");
        httpUrl$Builder.setEncodedUsername$okhttp(HttpUrl$Companion.canonicalize$okhttp$default(HttpUrl.Companion, string, 0, 0, " \"':;<=>@[]^`{}|/\\?#", false, false, false, false, null, 251, null));
        return httpUrl$Builder;
    }

    public final HttpUrl$Builder password(String string) {
        HttpUrl$Builder httpUrl$Builder = this;
        Intrinsics.checkNotNullParameter(string, "password");
        httpUrl$Builder.setEncodedPassword$okhttp(HttpUrl$Companion.canonicalize$okhttp$default(HttpUrl.Companion, string, 0, 0, " \"':;<=>@[]^`{}|/\\?#", false, false, false, false, null, 251, null));
        return httpUrl$Builder;
    }

    public final HttpUrl$Builder host(String string) {
        Intrinsics.checkNotNullParameter(string, "host");
        String string2 = HostnamesKt.toCanonicalHost(HttpUrl$Companion.percentDecode$okhttp$default(HttpUrl.Companion, string, 0, 0, false, 7, null));
        if (string2 != null) {
            HttpUrl$Builder httpUrl$Builder = this;
            httpUrl$Builder.setHost$okhttp(string2);
            return httpUrl$Builder;
        }
        throw new IllegalArgumentException(Intrinsics.stringPlus("unexpected host: ", string));
    }

    public final HttpUrl$Builder port(int n) {
        if (1 <= n && n < 65536) {
            HttpUrl$Builder httpUrl$Builder = string;
            httpUrl$Builder.setPort$okhttp(n);
            return httpUrl$Builder;
        }
        String string = Intrinsics.stringPlus("unexpected port: ", n);
        throw new IllegalArgumentException(string.toString());
    }

    public final HttpUrl$Builder addPathSegments(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "pathSegments");
        return this.addPathSegments(string2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final HttpUrl$Builder encodedQuery(String object) {
        HttpUrl$Companion httpUrl$Companion;
        object = object == null || (object = HttpUrl$Companion.canonicalize$okhttp$default(httpUrl$Companion = HttpUrl.Companion, (String)object, 0, 0, " \"'<>#", true, false, true, false, null, 211, null)) == null ? null : httpUrl$Companion.toQueryNamesAndValues$okhttp((String)object);
        HttpUrl$Builder httpUrl$Builder = this;
        httpUrl$Builder.setEncodedQueryNamesAndValues$okhttp((List)object);
        return httpUrl$Builder;
    }

    public final HttpUrl$Builder reencodeForUri$okhttp() {
        int n;
        String string = this.getHost$okhttp();
        string = string == null ? null : new Regex("[\"<>^`{|}]").replace((CharSequence)string, "");
        HttpUrl$Builder httpUrl$Builder = this;
        httpUrl$Builder.setHost$okhttp(string);
        int n2 = 0;
        int n3 = httpUrl$Builder.getEncodedPathSegments$okhttp().size();
        while (n2 < n3) {
            n = n2 + 1;
            this.getEncodedPathSegments$okhttp().set(n2, HttpUrl$Companion.canonicalize$okhttp$default(HttpUrl.Companion, (String)this.getEncodedPathSegments$okhttp().get(n2), 0, 0, "[]", true, true, false, false, null, 227, null));
            n2 = n;
        }
        Object object = this.getEncodedQueryNamesAndValues$okhttp();
        if (object != null) {
            n3 = 0;
            n = object.size();
            while (n3 < n) {
                int n4 = n3;
                int n5 = n4 + 1;
                String string2 = (String)object.get(n4);
                string2 = string2 == null ? null : HttpUrl$Companion.canonicalize$okhttp$default(HttpUrl.Companion, string2, 0, 0, "\\^`{|}", true, true, true, false, null, 195, null);
                object.set(n3, string2);
                n3 = n5;
            }
        }
        object = (object = this.getEncodedFragment$okhttp()) == null ? null : HttpUrl$Companion.canonicalize$okhttp$default(HttpUrl.Companion, (String)object, 0, 0, " \"#<>\\^`{|}", true, true, false, true, null, 163, null);
        HttpUrl$Builder httpUrl$Builder2 = this;
        httpUrl$Builder2.setEncodedFragment$okhttp((String)object);
        return httpUrl$Builder2;
    }

    public final HttpUrl build() {
        String string = ((HttpUrl$Builder)((Object)string6)).scheme;
        if (string != null) {
            HttpUrl$Companion httpUrl$Companion = HttpUrl.Companion;
            String string2 = HttpUrl$Companion.percentDecode$okhttp$default(httpUrl$Companion, ((HttpUrl$Builder)((Object)string6)).encodedUsername, 0, 0, false, 7, null);
            String string3 = HttpUrl$Companion.percentDecode$okhttp$default(httpUrl$Companion, ((HttpUrl$Builder)((Object)string6)).encodedPassword, 0, 0, false, 7, null);
            String string4 = ((HttpUrl$Builder)((Object)string6)).host;
            if (string4 != null) {
                Object object;
                ArrayList<String> arrayList;
                HttpUrl$Builder httpUrl$Builder = string6;
                int n = httpUrl$Builder.effectivePort();
                Object object2 = httpUrl$Builder.encodedPathSegments;
                ArrayList<String> arrayList2 = arrayList;
                arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, 10));
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    arrayList2.add(HttpUrl$Companion.percentDecode$okhttp$default(HttpUrl.Companion, (String)object2.next(), 0, 0, false, 7, null));
                }
                object2 = ((HttpUrl$Builder)((Object)string6)).encodedQueryNamesAndValues;
                if (object2 == null) {
                    object2 = null;
                } else {
                    ArrayList arrayList3;
                    object = arrayList3;
                    arrayList3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, 10));
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        String string5 = (String)object2.next();
                        string5 = string5 == null ? null : HttpUrl$Companion.percentDecode$okhttp$default(HttpUrl.Companion, string5, 0, 0, true, 3, null);
                        object.add(string5);
                    }
                    object2 = object;
                }
                object = ((HttpUrl$Builder)((Object)string6)).encodedFragment;
                object = object == null ? null : HttpUrl$Companion.percentDecode$okhttp$default(HttpUrl.Companion, (String)object, 0, 0, false, 7, null);
                String string6 = ((HttpUrl$Builder)((Object)string6)).toString();
                return new HttpUrl(string, string2, string3, string4, n, arrayList2, (List)object2, (String)object, string6);
            }
            throw new IllegalStateException("host == null");
        }
        throw new IllegalStateException("scheme == null");
    }

    public String toString() {
        StringBuilder stringBuilder;
        block12: {
            int n;
            block13: {
                StringBuilder stringBuilder2;
                stringBuilder = stringBuilder2;
                stringBuilder2 = new StringBuilder();
                if (this.getScheme$okhttp() != null) {
                    StringBuilder stringBuilder3 = stringBuilder;
                    stringBuilder3.append(this.getScheme$okhttp());
                    stringBuilder3.append("://");
                } else {
                    stringBuilder.append("//");
                }
                if (this.getEncodedUsername$okhttp().length() > 0 || this.getEncodedPassword$okhttp().length() > 0) {
                    stringBuilder.append(this.getEncodedUsername$okhttp());
                    if (this.getEncodedPassword$okhttp().length() > 0) {
                        stringBuilder.append(':');
                        stringBuilder.append(this.getEncodedPassword$okhttp());
                    }
                    stringBuilder.append('@');
                }
                if (this.getHost$okhttp() != null) {
                    String string = this.getHost$okhttp();
                    Intrinsics.checkNotNull(string);
                    if (StringsKt.contains$default((CharSequence)string, ':', false, 2, null)) {
                        StringBuilder stringBuilder4 = stringBuilder;
                        stringBuilder.append('[');
                        stringBuilder4.append(this.getHost$okhttp());
                        stringBuilder4.append(']');
                    } else {
                        stringBuilder.append(this.getHost$okhttp());
                    }
                }
                if (this.getPort$okhttp() == -1 && this.getScheme$okhttp() == null) break block12;
                HttpUrl$Builder httpUrl$Builder = this;
                n = httpUrl$Builder.effectivePort();
                if (httpUrl$Builder.getScheme$okhttp() == null) break block13;
                String string = this.getScheme$okhttp();
                Intrinsics.checkNotNull(string);
                if (n == HttpUrl.Companion.defaultPort(string)) break block12;
            }
            StringBuilder stringBuilder5 = stringBuilder;
            stringBuilder5.append(':');
            stringBuilder5.append(n);
        }
        Object object = HttpUrl.Companion;
        ((HttpUrl$Companion)object).toPathString$okhttp(this.getEncodedPathSegments$okhttp(), stringBuilder);
        if (this.getEncodedQueryNamesAndValues$okhttp() != null) {
            HttpUrl$Companion httpUrl$Companion = object;
            stringBuilder.append('?');
            object = this.getEncodedQueryNamesAndValues$okhttp();
            Intrinsics.checkNotNull(object);
            httpUrl$Companion.toQueryString$okhttp((List)object, stringBuilder);
        }
        if (this.getEncodedFragment$okhttp() != null) {
            stringBuilder.append('#');
            stringBuilder.append(this.getEncodedFragment$okhttp());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public final HttpUrl$Builder parse$okhttp(HttpUrl httpUrl, String string) {
        block20: {
            Object object;
            int n;
            int n2;
            block23: {
                int n3;
                int n4;
                block22: {
                    int n5;
                    int n6;
                    block21: {
                        HttpUrl$Builder$Companion httpUrl$Builder$Companion;
                        block18: {
                            block16: {
                                block19: {
                                    block17: {
                                        String string2 = string;
                                        Intrinsics.checkNotNullParameter(string2, "input");
                                        n4 = Util.indexOfFirstNonAsciiWhitespace$default(string2, 0, 0, 3, null);
                                        n3 = Util.indexOfLastNonAsciiWhitespace$default(string2, n4, 0, 2, null);
                                        httpUrl$Builder$Companion = Companion;
                                        n2 = HttpUrl$Builder$Companion.access$schemeDelimiterOffset(httpUrl$Builder$Companion, string, n4, n3);
                                        if (n2 == -1) break block16;
                                        if (!StringsKt.startsWith(string, "https:", n4, true)) break block17;
                                        ((HttpUrl$Builder)object).scheme = "https";
                                        n4 += 6;
                                        break block18;
                                    }
                                    if (!StringsKt.startsWith(string, "http:", n4, true)) break block19;
                                    ((HttpUrl$Builder)object).scheme = "http";
                                    n4 += 5;
                                    break block18;
                                }
                                StringBuilder stringBuilder = new StringBuilder().append("Expected URL scheme 'http' or 'https' but was '");
                                String string3 = string.substring(0, n2);
                                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                                throw new IllegalArgumentException(stringBuilder.append(string3).append('\'').toString());
                            }
                            if (httpUrl == null) break block20;
                            ((HttpUrl$Builder)object).scheme = httpUrl.scheme();
                        }
                        n6 = 0;
                        n2 = 0;
                        n5 = HttpUrl$Builder$Companion.access$slashCount(httpUrl$Builder$Companion, string, n4, n3);
                        if (n5 >= 2 || httpUrl == null || !Intrinsics.areEqual(httpUrl.scheme(), ((HttpUrl$Builder)object).scheme)) break block21;
                        HttpUrl$Builder httpUrl$Builder = object;
                        ((HttpUrl$Builder)object).encodedUsername = httpUrl.encodedUsername();
                        ((HttpUrl$Builder)object).encodedPassword = httpUrl.encodedPassword();
                        ((HttpUrl$Builder)object).host = httpUrl.host();
                        httpUrl$Builder.port = httpUrl.port();
                        httpUrl$Builder.encodedPathSegments.clear();
                        httpUrl$Builder.encodedPathSegments.addAll(httpUrl.encodedPathSegments());
                        if (n4 == n3 || string.charAt(n4) == '#') {
                            ((HttpUrl$Builder)object).encodedQuery(httpUrl.encodedQuery());
                        }
                        break block22;
                    }
                    n = n4 + n5;
                    while ((n5 = (n4 = Util.delimiterOffset(string, "@/\\?#", n, n3)) != n3 ? (int)string.charAt(n4) : -1) != -1 && n5 != 35 && n5 != 47 && n5 != 92 && n5 != 63) {
                        if (n5 != 64) continue;
                        if (n2 == 0) {
                            int n7 = n6;
                            n6 = Util.delimiterOffset(string, ':', n, n4);
                            HttpUrl$Companion httpUrl$Companion = HttpUrl.Companion;
                            String string4 = HttpUrl$Companion.canonicalize$okhttp$default(httpUrl$Companion, string, n, n6, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, null, 240, null);
                            if (n7 != 0) {
                                string4 = ((HttpUrl$Builder)object).encodedUsername + "%40" + string4;
                            }
                            ((HttpUrl$Builder)object).encodedUsername = string4;
                            if (n6 != n4) {
                                n2 = 1;
                                ((HttpUrl$Builder)object).encodedPassword = HttpUrl$Companion.canonicalize$okhttp$default(httpUrl$Companion, string, n6 + 1, n4, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, null, 240, null);
                            }
                            n6 = n = 1;
                        } else {
                            ((HttpUrl$Builder)object).encodedPassword = ((HttpUrl$Builder)object).encodedPassword + "%40" + HttpUrl$Companion.canonicalize$okhttp$default(HttpUrl.Companion, string, n, n4, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, null, 240, null);
                        }
                        n = n4 + 1;
                    }
                    Object object2 = Companion;
                    n2 = HttpUrl$Builder$Companion.access$portColonOffset((HttpUrl$Builder$Companion)object2, string, n, n4);
                    n5 = n2 + 1;
                    if (n5 < n4) {
                        ((HttpUrl$Builder)object).host = HostnamesKt.toCanonicalHost(HttpUrl$Companion.percentDecode$okhttp$default(HttpUrl.Companion, string, n, n2, false, 4, null));
                        ((HttpUrl$Builder)object).port = HttpUrl$Builder$Companion.access$parsePort((HttpUrl$Builder$Companion)object2, string, n5, n4);
                        if (!(((HttpUrl$Builder)object).port != -1)) {
                            StringBuilder stringBuilder = new StringBuilder().append("Invalid URL port: \"");
                            String string5 = string.substring(n5, n4);
                            Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                            object = stringBuilder.append(string5).append('\"').toString();
                            throw new IllegalArgumentException(object.toString());
                        }
                    } else {
                        object2 = HttpUrl.Companion;
                        ((HttpUrl$Builder)object).host = HostnamesKt.toCanonicalHost(HttpUrl$Companion.percentDecode$okhttp$default((HttpUrl$Companion)object2, string, n, n2, false, 4, null));
                        String string6 = ((HttpUrl$Builder)object).scheme;
                        Intrinsics.checkNotNull(string6);
                        ((HttpUrl$Builder)object).port = ((HttpUrl$Companion)object2).defaultPort(string6);
                    }
                    if (!(((HttpUrl$Builder)object).host != null)) break block23;
                }
                int n8 = Util.delimiterOffset(string, "?#", n4, n3);
                ((HttpUrl$Builder)object).resolvePath(string, n4, n8);
                if (n8 < n3 && string.charAt(n8) == '?') {
                    n4 = Util.delimiterOffset(string, '#', n8, n3);
                    HttpUrl$Companion httpUrl$Companion = HttpUrl.Companion;
                    ((HttpUrl$Builder)object).encodedQueryNamesAndValues = httpUrl$Companion.toQueryNamesAndValues$okhttp(HttpUrl$Companion.canonicalize$okhttp$default(httpUrl$Companion, string, n8 + 1, n4, " \"'<>#", true, false, true, false, null, 208, null));
                    n8 = n4;
                }
                if (n8 < n3 && string.charAt(n8) == '#') {
                    ((HttpUrl$Builder)object).encodedFragment = HttpUrl$Companion.canonicalize$okhttp$default(HttpUrl.Companion, string, n8 + 1, n3, "", true, false, false, true, null, 176, null);
                }
                return object;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Invalid URL host: \"");
            String string7 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string7, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            object = stringBuilder.append(string7).append('\"').toString();
            throw new IllegalArgumentException(object.toString());
        }
        if (string.length() > 6) {
            string = Intrinsics.stringPlus(StringsKt.take(string, 6), "...");
        }
        throw new IllegalArgumentException(Intrinsics.stringPlus("Expected URL scheme 'http' or 'https' but no scheme was found for ", string));
    }
}

