/*
 * Decompiled with CFR 0.152.
 */
package link.infra.packwiz.installer.deps.commons-cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import link.infra.packwiz.installer.deps.commons-cli.OptionValidator;

public class Option
implements Cloneable,
Serializable {
    private final String option;
    private String longOption;
    private String description;
    private boolean required;
    private boolean optionalArg;
    private int argCount = -1;
    private Class type = String.class;
    private List values = new ArrayList();
    private char valuesep;

    public Option(String string, String string2, boolean bl, String string3) {
        this.option = OptionValidator.validate(string);
        this.longOption = string2;
        if (bl) {
            this.argCount = 1;
        }
        this.description = string3;
    }

    private void add(String string) {
        if (this.acceptsArg()) {
            this.values.add(string);
            return;
        }
        throw new RuntimeException("Cannot add value, list full.");
    }

    private boolean hasNoValues() {
        return this.values.isEmpty();
    }

    private void processValue(String string) {
        if (this.hasValueSeparator()) {
            char c = this.getValueSeparator();
            int n = string.indexOf(c);
            while (n != -1 && this.values.size() != this.argCount - 1) {
                this.add(string.substring(0, n));
                string = string.substring(n + 1);
                n = string.indexOf(c);
            }
        }
        this.add(string);
    }

    boolean acceptsArg() {
        return !(!this.hasArg() && !this.hasArgs() && !this.hasOptionalArg() || this.argCount > 0 && this.values.size() >= this.argCount);
    }

    void addValueForProcessing(String string) {
        if (this.argCount != -1) {
            this.processValue(string);
            return;
        }
        throw new RuntimeException("NO_ARGS_ALLOWED");
    }

    public Object clone() {
        try {
            ((Option)super.clone()).values = new ArrayList(this.values);
            return (Option)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("A CloneNotSupportedException was thrown: " + cloneNotSupportedException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Option)) {
            return false;
        }
        object = (Option)object;
        return Objects.equals(this.longOption, ((Option)object).longOption) && Objects.equals(this.option, ((Option)object).option);
    }

    public int getArgs() {
        return this.argCount;
    }

    String getKey() {
        String string = this.option;
        if (string == null) {
            string = this.longOption;
        }
        return string;
    }

    public String getLongOpt() {
        return this.longOption;
    }

    public String getOpt() {
        return this.option;
    }

    public String[] getValues() {
        String[] stringArray;
        if (this.hasNoValues()) {
            stringArray = null;
        } else {
            List list = this.values;
            stringArray = list.toArray(new String[list.size()]);
        }
        return stringArray;
    }

    public char getValueSeparator() {
        return this.valuesep;
    }

    public List getValuesList() {
        return this.values;
    }

    public boolean hasArg() {
        int n = this.argCount;
        return n > 0 || n == -2;
    }

    public boolean hasArgs() {
        int n = this.argCount;
        return n > 1 || n == -2;
    }

    public int hashCode() {
        return Objects.hash(this.longOption, this.option);
    }

    public boolean hasLongOpt() {
        return this.longOption != null;
    }

    public boolean hasOptionalArg() {
        return this.optionalArg;
    }

    public boolean hasValueSeparator() {
        return this.valuesep > '\u0000';
    }

    public boolean isRequired() {
        return this.required;
    }

    boolean requiresArg() {
        if (this.optionalArg) {
            return false;
        }
        if (this.argCount == -2) {
            return this.values.isEmpty();
        }
        return this.acceptsArg();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("[ option: ");
        stringBuilder.append(this.option);
        if (this.longOption != null) {
            stringBuilder.append(" ").append(this.longOption);
        }
        stringBuilder.append(" ");
        if (this.hasArgs()) {
            stringBuilder.append("[ARG...]");
        } else if (this.hasArg()) {
            stringBuilder.append(" [ARG]");
        }
        stringBuilder.append(" :: ").append(this.description);
        if (this.type != null) {
            stringBuilder.append(" :: ").append(this.type);
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.append(" ]");
        return stringBuilder2.toString();
    }
}

