/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.model;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.jvm.internal.impl.types.model.ArgumentList;
import kotlin.reflect.jvm.internal.impl.types.model.FlexibleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentListMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeConstructorMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;

public abstract class TypeSystemContext$DefaultImpls {
    public static boolean isCapturedType(TypeSystemContext typeSystemContext, KotlinTypeMarker kotlinTypeMarker) {
        Intrinsics.checkNotNullParameter(kotlinTypeMarker, "$receiver");
        kotlinTypeMarker = typeSystemContext.asSimpleType(kotlinTypeMarker);
        return (kotlinTypeMarker != null ? typeSystemContext.asCapturedType((SimpleTypeMarker)kotlinTypeMarker) : null) != null;
    }

    public static boolean isMarkedNullable(TypeSystemContext typeSystemContext, KotlinTypeMarker kotlinTypeMarker) {
        KotlinTypeMarker kotlinTypeMarker2 = kotlinTypeMarker;
        Intrinsics.checkNotNullParameter(kotlinTypeMarker2, "$receiver");
        return kotlinTypeMarker2 instanceof SimpleTypeMarker && typeSystemContext.isMarkedNullable((SimpleTypeMarker)kotlinTypeMarker);
    }

    public static TypeArgumentMarker getArgumentOrNull(TypeSystemContext typeSystemContext, SimpleTypeMarker simpleTypeMarker, int n) {
        Intrinsics.checkNotNullParameter(simpleTypeMarker, "$receiver");
        if (n >= 0 && n < typeSystemContext.argumentsCount(simpleTypeMarker)) {
            return typeSystemContext.getArgument(simpleTypeMarker, n);
        }
        return null;
    }

    public static SimpleTypeMarker lowerBoundIfFlexible(TypeSystemContext typeSystemContext, KotlinTypeMarker kotlinTypeMarker) {
        Intrinsics.checkNotNullParameter(kotlinTypeMarker, "$receiver");
        KotlinTypeMarker kotlinTypeMarker2 = typeSystemContext.asFlexibleType(kotlinTypeMarker);
        if (kotlinTypeMarker2 == null || (kotlinTypeMarker2 = typeSystemContext.lowerBound((FlexibleTypeMarker)kotlinTypeMarker2)) == null) {
            kotlinTypeMarker2 = typeSystemContext.asSimpleType(kotlinTypeMarker);
            Intrinsics.checkNotNull(kotlinTypeMarker2);
        }
        return kotlinTypeMarker2;
    }

    public static SimpleTypeMarker upperBoundIfFlexible(TypeSystemContext typeSystemContext, KotlinTypeMarker kotlinTypeMarker) {
        Intrinsics.checkNotNullParameter(kotlinTypeMarker, "$receiver");
        KotlinTypeMarker kotlinTypeMarker2 = typeSystemContext.asFlexibleType(kotlinTypeMarker);
        if (kotlinTypeMarker2 == null || (kotlinTypeMarker2 = typeSystemContext.upperBound((FlexibleTypeMarker)kotlinTypeMarker2)) == null) {
            kotlinTypeMarker2 = typeSystemContext.asSimpleType(kotlinTypeMarker);
            Intrinsics.checkNotNull(kotlinTypeMarker2);
        }
        return kotlinTypeMarker2;
    }

    public static boolean isDynamic(TypeSystemContext typeSystemContext, KotlinTypeMarker kotlinTypeMarker) {
        Intrinsics.checkNotNullParameter(kotlinTypeMarker, "$receiver");
        kotlinTypeMarker = typeSystemContext.asFlexibleType(kotlinTypeMarker);
        return (kotlinTypeMarker != null ? typeSystemContext.asDynamicType((FlexibleTypeMarker)kotlinTypeMarker) : null) != null;
    }

    public static boolean isDefinitelyNotNullType(TypeSystemContext typeSystemContext, KotlinTypeMarker kotlinTypeMarker) {
        Intrinsics.checkNotNullParameter(kotlinTypeMarker, "$receiver");
        kotlinTypeMarker = typeSystemContext.asSimpleType(kotlinTypeMarker);
        return (kotlinTypeMarker != null ? typeSystemContext.asDefinitelyNotNullType((SimpleTypeMarker)kotlinTypeMarker) : null) != null;
    }

    public static boolean hasFlexibleNullability(TypeSystemContext typeSystemContext, KotlinTypeMarker kotlinTypeMarker) {
        TypeSystemContext typeSystemContext2 = typeSystemContext;
        KotlinTypeMarker kotlinTypeMarker2 = kotlinTypeMarker;
        Intrinsics.checkNotNullParameter(kotlinTypeMarker2, "$receiver");
        TypeSystemContext typeSystemContext3 = typeSystemContext;
        return typeSystemContext2.isMarkedNullable(typeSystemContext2.lowerBoundIfFlexible(kotlinTypeMarker2)) != typeSystemContext3.isMarkedNullable(typeSystemContext3.upperBoundIfFlexible(kotlinTypeMarker));
    }

    public static TypeConstructorMarker typeConstructor(TypeSystemContext typeSystemContext, KotlinTypeMarker kotlinTypeMarker) {
        Intrinsics.checkNotNullParameter(kotlinTypeMarker, "$receiver");
        SimpleTypeMarker simpleTypeMarker = typeSystemContext.asSimpleType(kotlinTypeMarker);
        if (simpleTypeMarker == null) {
            simpleTypeMarker = typeSystemContext.lowerBoundIfFlexible(kotlinTypeMarker);
        }
        return typeSystemContext.typeConstructor(simpleTypeMarker);
    }

    public static boolean isNothing(TypeSystemContext typeSystemContext, KotlinTypeMarker kotlinTypeMarker) {
        TypeSystemContext typeSystemContext2 = typeSystemContext;
        KotlinTypeMarker kotlinTypeMarker2 = kotlinTypeMarker;
        Intrinsics.checkNotNullParameter(kotlinTypeMarker2, "$receiver");
        return typeSystemContext2.isNothingConstructor(typeSystemContext2.typeConstructor(kotlinTypeMarker2)) && !typeSystemContext.isNullableType(kotlinTypeMarker);
    }

    public static boolean isClassType(TypeSystemContext typeSystemContext, SimpleTypeMarker simpleTypeMarker) {
        TypeSystemContext typeSystemContext2 = typeSystemContext;
        SimpleTypeMarker simpleTypeMarker2 = simpleTypeMarker;
        Intrinsics.checkNotNullParameter(simpleTypeMarker2, "$receiver");
        return typeSystemContext2.isClassTypeConstructor(typeSystemContext2.typeConstructor(simpleTypeMarker2));
    }

    public static List fastCorrespondingSupertypes(TypeSystemContext typeSystemContext, SimpleTypeMarker simpleTypeMarker, TypeConstructorMarker typeConstructorMarker) {
        Intrinsics.checkNotNullParameter(simpleTypeMarker, "$receiver");
        Intrinsics.checkNotNullParameter(typeConstructorMarker, "constructor");
        return null;
    }

    public static boolean isIntegerLiteralType(TypeSystemContext typeSystemContext, SimpleTypeMarker simpleTypeMarker) {
        TypeSystemContext typeSystemContext2 = typeSystemContext;
        SimpleTypeMarker simpleTypeMarker2 = simpleTypeMarker;
        Intrinsics.checkNotNullParameter(simpleTypeMarker2, "$receiver");
        return typeSystemContext2.isIntegerLiteralTypeConstructor(typeSystemContext2.typeConstructor(simpleTypeMarker2));
    }

    public static TypeArgumentMarker get(TypeSystemContext typeSystemContext, TypeArgumentListMarker typeArgumentListMarker, int n) {
        block4: {
            TypeArgumentMarker typeArgumentMarker;
            block3: {
                block2: {
                    TypeArgumentListMarker typeArgumentListMarker2 = typeArgumentListMarker;
                    Intrinsics.checkNotNullParameter(typeArgumentListMarker2, "$receiver");
                    if (!(typeArgumentListMarker2 instanceof SimpleTypeMarker)) break block2;
                    typeArgumentMarker = typeSystemContext.getArgument((KotlinTypeMarker)((Object)typeArgumentListMarker), n);
                    break block3;
                }
                if (!(typeArgumentListMarker instanceof ArgumentList)) break block4;
                Object e = ((ArgumentList)typeArgumentListMarker).get(n);
                Intrinsics.checkNotNullExpressionValue(e, "get(index)");
                typeArgumentMarker = (TypeArgumentMarker)e;
            }
            return typeArgumentMarker;
        }
        throw new IllegalStateException(("unknown type argument list type: " + typeArgumentListMarker + ", " + Reflection.getOrCreateKotlinClass(typeArgumentListMarker.getClass())).toString());
    }

    public static int size(TypeSystemContext typeSystemContext, TypeArgumentListMarker typeArgumentListMarker) {
        block4: {
            int n;
            block3: {
                block2: {
                    TypeArgumentListMarker typeArgumentListMarker2 = typeArgumentListMarker;
                    Intrinsics.checkNotNullParameter(typeArgumentListMarker2, "$receiver");
                    if (!(typeArgumentListMarker2 instanceof SimpleTypeMarker)) break block2;
                    n = typeSystemContext.argumentsCount((KotlinTypeMarker)((Object)typeArgumentListMarker));
                    break block3;
                }
                if (!(typeArgumentListMarker instanceof ArgumentList)) break block4;
                n = ((ArgumentList)typeArgumentListMarker).size();
            }
            return n;
        }
        throw new IllegalStateException(("unknown type argument list type: " + typeArgumentListMarker + ", " + Reflection.getOrCreateKotlinClass(typeArgumentListMarker.getClass())).toString());
    }
}

