/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.types.CustomTypeParameter;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeImpl$Companion;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class FlexibleTypeImpl
extends FlexibleType
implements CustomTypeParameter {
    public static final FlexibleTypeImpl$Companion Companion = new FlexibleTypeImpl$Companion(null);
    public static boolean RUN_SLOW_ASSERTIONS;
    private boolean assertionsDone;

    public FlexibleTypeImpl(SimpleType simpleType2, SimpleType simpleType3) {
        Intrinsics.checkNotNullParameter(simpleType2, "lowerBound");
        Intrinsics.checkNotNullParameter(simpleType3, "upperBound");
        super(simpleType2, simpleType3);
    }

    private final void runAssertions() {
        if (RUN_SLOW_ASSERTIONS && !((FlexibleTypeImpl)object).assertionsDone) {
            Object object;
            ((FlexibleTypeImpl)object).assertionsDone = true;
            boolean bl = FlexibleTypesKt.isFlexible(((FlexibleType)object).getLowerBound()) ^ true;
            boolean bl2 = _Assertions.ENABLED;
            if (bl2 && !bl) {
                object = "Lower bound of a flexible type can not be flexible: " + ((FlexibleType)object).getLowerBound();
                throw new AssertionError(object);
            }
            bl = FlexibleTypesKt.isFlexible(((FlexibleType)object).getUpperBound()) ^ true;
            if (bl2 && !bl) {
                object = "Upper bound of a flexible type can not be flexible: " + ((FlexibleType)object).getUpperBound();
                throw new AssertionError(object);
            }
            bl = Intrinsics.areEqual(((FlexibleType)object).getLowerBound(), ((FlexibleType)object).getUpperBound()) ^ true;
            if (bl2 && !bl) {
                object = "Lower and upper bounds are equal: " + ((FlexibleType)object).getLowerBound() + " == " + ((FlexibleType)object).getUpperBound();
                throw new AssertionError(object);
            }
            Object object2 = object;
            SimpleType simpleType2 = ((FlexibleType)object2).getLowerBound();
            boolean bl3 = KotlinTypeChecker.DEFAULT.isSubtypeOf(simpleType2, ((FlexibleType)object2).getUpperBound());
            if (bl2 && !bl3) {
                object = "Lower bound " + ((FlexibleType)object).getLowerBound() + " of a flexible type must be a subtype of the upper bound " + ((FlexibleType)object).getUpperBound();
                throw new AssertionError(object);
            }
            return;
        }
    }

    @Override
    public SimpleType getDelegate() {
        FlexibleTypeImpl flexibleTypeImpl = this;
        flexibleTypeImpl.runAssertions();
        return flexibleTypeImpl.getLowerBound();
    }

    @Override
    public boolean isTypeParameter() {
        return this.getLowerBound().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor && Intrinsics.areEqual(this.getLowerBound().getConstructor(), this.getUpperBound().getConstructor());
    }

    @Override
    public KotlinType substitutionResult(KotlinType kotlinType) {
        block4: {
            block3: {
                block2: {
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkNotNullParameter(kotlinType2, "replacement");
                    UnwrappedType unwrappedType = kotlinType2.unwrap();
                    if (!(unwrappedType instanceof FlexibleType)) break block2;
                    kotlinType = unwrappedType;
                    break block3;
                }
                if (!(unwrappedType instanceof SimpleType)) break block4;
                SimpleType simpleType2 = (SimpleType)unwrappedType;
                kotlinType = KotlinTypeFactory.flexibleType(simpleType2, simpleType2.makeNullableAsSpecified(true));
            }
            return TypeWithEnhancementKt.inheritEnhancement((UnwrappedType)kotlinType, unwrappedType);
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    public UnwrappedType replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter(typeAttributes, "newAttributes");
        return KotlinTypeFactory.flexibleType(this.getLowerBound().replaceAttributes(typeAttributes), this.getUpperBound().replaceAttributes(typeAttributes));
    }

    @Override
    public String render(DescriptorRenderer object, DescriptorRendererOptions object2) {
        DescriptorRendererOptions descriptorRendererOptions = object2;
        Intrinsics.checkNotNullParameter(object, "renderer");
        Intrinsics.checkNotNullParameter(descriptorRendererOptions, "options");
        if (descriptorRendererOptions.getDebugMode()) {
            return '(' + ((DescriptorRenderer)object).renderType(((FlexibleType)((Object)string)).getLowerBound()) + ".." + ((DescriptorRenderer)object).renderType(((FlexibleType)((Object)string)).getUpperBound()) + ')';
        }
        DescriptorRenderer descriptorRenderer2 = object;
        FlexibleTypeImpl flexibleTypeImpl = string;
        FlexibleTypeImpl flexibleTypeImpl2 = string;
        String string = ((DescriptorRenderer)object).renderType(((FlexibleType)((Object)string)).getLowerBound());
        object = ((DescriptorRenderer)object).renderType(flexibleTypeImpl2.getUpperBound());
        object2 = TypeUtilsKt.getBuiltIns(flexibleTypeImpl);
        return descriptorRenderer2.renderFlexibleType(string, (String)object, (KotlinBuiltIns)object2);
    }

    @Override
    public String toString() {
        return "" + '(' + this.getLowerBound() + ".." + this.getUpperBound() + ')';
    }

    @Override
    public UnwrappedType makeNullableAsSpecified(boolean bl) {
        return KotlinTypeFactory.flexibleType(this.getLowerBound().makeNullableAsSpecified(bl), this.getUpperBound().makeNullableAsSpecified(bl));
    }

    @Override
    public FlexibleType refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        FlexibleTypeImpl flexibleTypeImpl = unwrappedType;
        KotlinType kotlinType = kotlinTypeRefiner.refineType(unwrappedType.getLowerBound());
        Intrinsics.checkNotNull(kotlinType, "null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        UnwrappedType unwrappedType = (SimpleType)kotlinType;
        KotlinType kotlinType2 = kotlinTypeRefiner.refineType(flexibleTypeImpl.getUpperBound());
        Intrinsics.checkNotNull(kotlinType2, "null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        return new FlexibleTypeImpl((SimpleType)unwrappedType, (SimpleType)kotlinType2);
    }
}

