/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ChainedMemberScope$Companion;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScopeKt;
import kotlin.reflect.jvm.internal.impl.util.collectionUtils.ScopeUtilsKt;

public final class ChainedMemberScope
implements MemberScope {
    public static final ChainedMemberScope$Companion Companion = new ChainedMemberScope$Companion(null);
    private final String debugName;
    private final MemberScope[] scopes;

    private ChainedMemberScope(String string, MemberScope[] memberScopeArray) {
        this.debugName = string;
        this.scopes = memberScopeArray;
    }

    public static final /* synthetic */ MemberScope[] access$getScopes$p(ChainedMemberScope chainedMemberScope) {
        return chainedMemberScope.scopes;
    }

    public /* synthetic */ ChainedMemberScope(String string, MemberScope[] memberScopeArray, DefaultConstructorMarker defaultConstructorMarker) {
        this(string, memberScopeArray);
    }

    @Override
    public ClassifierDescriptor getContributedClassifier(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(lookupLocation, "location");
        MemberScope[] memberScopeArray = memberScopeArray.scopes;
        ClassifierDescriptor classifierDescriptor = null;
        int n = memberScopeArray.scopes.length;
        for (int i = 0; i < n; ++i) {
            ClassifierDescriptor classifierDescriptor2 = memberScopeArray[i].getContributedClassifier(name, lookupLocation);
            if (classifierDescriptor2 == null) continue;
            if (classifierDescriptor2 instanceof ClassifierDescriptorWithTypeParameters && ((ClassifierDescriptorWithTypeParameters)classifierDescriptor2).isExpect()) {
                if (classifierDescriptor != null) continue;
                classifierDescriptor = classifierDescriptor2;
                continue;
            }
            classifierDescriptor = classifierDescriptor2;
            break;
        }
        return classifierDescriptor;
    }

    @Override
    public Collection getContributedVariables(Name name, LookupLocation lookupLocation) {
        Collection collection;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(lookupLocation, "location");
        MemberScope[] memberScopeArray = memberScopeArray.scopes;
        int n = memberScopeArray.scopes.length;
        if (n != 0) {
            if (n != 1) {
                collection = null;
                int n2 = memberScopeArray.length;
                for (int i = 0; i < n2; ++i) {
                    collection = ScopeUtilsKt.concat(collection, memberScopeArray[i].getContributedVariables(name, lookupLocation));
                }
                if (collection == null) {
                    collection = SetsKt.emptySet();
                }
            } else {
                collection = memberScopeArray[0].getContributedVariables(name, lookupLocation);
            }
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @Override
    public Collection getContributedFunctions(Name name, LookupLocation lookupLocation) {
        Collection collection;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(lookupLocation, "location");
        MemberScope[] memberScopeArray = memberScopeArray.scopes;
        int n = memberScopeArray.scopes.length;
        if (n != 0) {
            if (n != 1) {
                collection = null;
                int n2 = memberScopeArray.length;
                for (int i = 0; i < n2; ++i) {
                    collection = ScopeUtilsKt.concat(collection, memberScopeArray[i].getContributedFunctions(name, lookupLocation));
                }
                if (collection == null) {
                    collection = SetsKt.emptySet();
                }
            } else {
                collection = memberScopeArray[0].getContributedFunctions(name, lookupLocation);
            }
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @Override
    public Collection getContributedDescriptors(DescriptorKindFilter descriptorKindFilter, Function1 function1) {
        Collection collection;
        Intrinsics.checkNotNullParameter(descriptorKindFilter, "kindFilter");
        Intrinsics.checkNotNullParameter(function1, "nameFilter");
        MemberScope[] memberScopeArray = memberScopeArray.scopes;
        int n = memberScopeArray.scopes.length;
        if (n != 0) {
            if (n != 1) {
                collection = null;
                int n2 = memberScopeArray.length;
                for (int i = 0; i < n2; ++i) {
                    collection = ScopeUtilsKt.concat(collection, memberScopeArray[i].getContributedDescriptors(descriptorKindFilter, function1));
                }
                if (collection == null) {
                    collection = SetsKt.emptySet();
                }
            } else {
                collection = memberScopeArray[0].getContributedDescriptors(descriptorKindFilter, function1);
            }
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @Override
    public Set getFunctionNames() {
        LinkedHashSet linkedHashSet;
        MemberScope[] memberScopeArray = memberScopeArray.scopes;
        LinkedHashSet linkedHashSet2 = linkedHashSet;
        linkedHashSet = new LinkedHashSet();
        int n = memberScopeArray.scopes.length;
        for (int i = 0; i < n; ++i) {
            CollectionsKt.addAll(linkedHashSet2, memberScopeArray[i].getFunctionNames());
        }
        return linkedHashSet2;
    }

    @Override
    public Set getVariableNames() {
        LinkedHashSet linkedHashSet;
        MemberScope[] memberScopeArray = memberScopeArray.scopes;
        LinkedHashSet linkedHashSet2 = linkedHashSet;
        linkedHashSet = new LinkedHashSet();
        int n = memberScopeArray.scopes.length;
        for (int i = 0; i < n; ++i) {
            CollectionsKt.addAll(linkedHashSet2, memberScopeArray[i].getVariableNames());
        }
        return linkedHashSet2;
    }

    @Override
    public Set getClassifierNames() {
        return MemberScopeKt.flatMapClassifierNamesOrNull(ArraysKt.asIterable(this.scopes));
    }

    public String toString() {
        return this.debugName;
    }
}

