/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil;

import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref$ObjectRef;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.InlineClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaPackageScope$classes$1$$ExternalSyntheticThrowCCEIfNotNull0;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt$declaresOrInheritsDefaultValue$1;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt$declaresOrInheritsDefaultValue$2;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt$firstOverridden$1;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt$firstOverridden$2;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt$parentsWithSelf$1;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner$Default;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefinerKt;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;

public abstract class DescriptorUtilsKt {
    private static final Name RETENTION_PARAMETER_NAME;

    public static final FqNameUnsafe getFqNameUnsafe(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        Intrinsics.checkNotNullParameter(declarationDescriptor2, "<this>");
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(declarationDescriptor2);
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "getFqName(this)");
        return fqNameUnsafe;
    }

    public static final FqName getFqNameSafe(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        Intrinsics.checkNotNullParameter(declarationDescriptor2, "<this>");
        FqName fqName2 = DescriptorUtils.getFqNameSafe(declarationDescriptor2);
        Intrinsics.checkNotNullExpressionValue(fqName2, "getFqNameSafe(this)");
        return fqName2;
    }

    public static final ModuleDescriptor getModule(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        Intrinsics.checkNotNullParameter(declarationDescriptor2, "<this>");
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(declarationDescriptor2);
        Intrinsics.checkNotNullExpressionValue(moduleDescriptor, "getContainingModule(this)");
        return moduleDescriptor;
    }

    public static final ClassDescriptor resolveTopLevelClass(ModuleDescriptor declarationDescriptor, FqName fqName2, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter(declarationDescriptor, "<this>");
        Intrinsics.checkNotNullParameter(fqName2, "topLevelClassFqName");
        Intrinsics.checkNotNullParameter(lookupLocation, "location");
        boolean bl = fqName2.isRoot() ^ true;
        if (_Assertions.ENABLED && !bl) {
            throw new AssertionError((Object)"Assertion failed");
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue(fqName3, "topLevelClassFqName.parent()");
        MemberScope memberScope2 = declarationDescriptor.getPackage(fqName3).getMemberScope();
        Name name = fqName2.shortName();
        Intrinsics.checkNotNullExpressionValue(name, "topLevelClassFqName.shortName()");
        declarationDescriptor = memberScope2.getContributedClassifier(name, lookupLocation);
        return declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ClassId getClassId(ClassifierDescriptor object) {
        ClassId classId;
        if (object == null) return null;
        Object object2 = object.getContainingDeclaration();
        if (object2 == null) return null;
        if (!(object2 instanceof PackageFragmentDescriptor)) {
            if (!(object2 instanceof ClassifierDescriptorWithTypeParameters)) return null;
            if ((object2 = DescriptorUtilsKt.getClassId((ClassifierDescriptor)object2)) == null) return null;
            return ((ClassId)object2).createNestedClassId(object.getName());
        }
        ClassId classId2 = classId;
        Object object3 = object;
        object = ((PackageFragmentDescriptor)object2).getFqName();
        classId = new ClassId((FqName)object, object3.getName());
        return classId2;
    }

    public static final ClassDescriptor getSuperClassNotAny(ClassDescriptor object) {
        ClassDescriptor classDescriptor = object;
        Intrinsics.checkNotNullParameter(classDescriptor, "<this>");
        for (Annotated annotated : classDescriptor.getDefaultType().getConstructor().getSupertypes()) {
            if (KotlinBuiltIns.isAnyOrNullableAny(annotated) || !DescriptorUtils.isClassOrEnumClass((DeclarationDescriptor)(annotated = annotated.getConstructor().getDeclarationDescriptor()))) continue;
            Annotated annotated2 = annotated;
            Intrinsics.checkNotNull(annotated2, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            return (ClassDescriptor)annotated2;
        }
        return null;
    }

    public static final KotlinBuiltIns getBuiltIns(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        Intrinsics.checkNotNullParameter(declarationDescriptor2, "<this>");
        return DescriptorUtilsKt.getModule(declarationDescriptor2).getBuiltIns();
    }

    public static final boolean declaresOrInheritsDefaultValue(ValueParameterDescriptor valueParameterDescriptor) {
        ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor;
        Intrinsics.checkNotNullParameter(valueParameterDescriptor2, "<this>");
        Boolean bl = DFS.ifAny(CollectionsKt.listOf((Object)valueParameterDescriptor2), DescriptorUtilsKt$declaresOrInheritsDefaultValue$1.INSTANCE, DescriptorUtilsKt$declaresOrInheritsDefaultValue$2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(bl, "ifAny(\n        listOf(th\u2026eclaresDefaultValue\n    )");
        return bl;
    }

    public static final Sequence getParentsWithSelf(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        Intrinsics.checkNotNullParameter(declarationDescriptor2, "<this>");
        return SequencesKt.generateSequence(declarationDescriptor2, DescriptorUtilsKt$parentsWithSelf$1.INSTANCE);
    }

    public static final Sequence getParents(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        Intrinsics.checkNotNullParameter(declarationDescriptor2, "<this>");
        return SequencesKt.drop(DescriptorUtilsKt.getParentsWithSelf(declarationDescriptor2), 1);
    }

    public static final CallableMemberDescriptor getPropertyIfAccessor(CallableMemberDescriptor callableMemberDescriptor) {
        CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
        Intrinsics.checkNotNullParameter(callableMemberDescriptor2, "<this>");
        if (callableMemberDescriptor2 instanceof PropertyAccessorDescriptor) {
            callableMemberDescriptor = ((PropertyAccessorDescriptor)callableMemberDescriptor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue(callableMemberDescriptor, "correspondingProperty");
        }
        return callableMemberDescriptor;
    }

    public static final FqName fqNameOrNull(DeclarationDescriptor object) {
        DeclarationDescriptor declarationDescriptor = object;
        Intrinsics.checkNotNullParameter(declarationDescriptor, "<this>");
        object = DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor);
        if (!((FqNameUnsafe)object).isSafe()) {
            object = null;
        }
        return object != null ? ((FqNameUnsafe)object).toSafe() : null;
    }

    public static final CallableMemberDescriptor firstOverridden(CallableMemberDescriptor object, boolean bl, Function1 function1) {
        DescriptorUtilsKt$firstOverridden$2 descriptorUtilsKt$firstOverridden$2;
        Ref$ObjectRef ref$ObjectRef;
        CallableMemberDescriptor callableMemberDescriptor = object;
        Intrinsics.checkNotNullParameter(object, "<this>");
        Intrinsics.checkNotNullParameter(function1, "predicate");
        object = ref$ObjectRef;
        ref$ObjectRef = new Ref$ObjectRef();
        DescriptorUtilsKt$firstOverridden$2 descriptorUtilsKt$firstOverridden$22 = descriptorUtilsKt$firstOverridden$2;
        descriptorUtilsKt$firstOverridden$2 = new DescriptorUtilsKt$firstOverridden$2((Ref$ObjectRef)object, function1);
        return (CallableMemberDescriptor)DFS.dfs(CollectionsKt.listOf((Object)callableMemberDescriptor), new DescriptorUtilsKt$firstOverridden$1(bl), descriptorUtilsKt$firstOverridden$22);
    }

    public static /* synthetic */ CallableMemberDescriptor firstOverridden$default(CallableMemberDescriptor callableMemberDescriptor, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return DescriptorUtilsKt.firstOverridden(callableMemberDescriptor, bl, function1);
    }

    public static final ClassDescriptor getAnnotationClass(AnnotationDescriptor object) {
        AnnotationDescriptor annotationDescriptor = object;
        Intrinsics.checkNotNullParameter(annotationDescriptor, "<this>");
        object = annotationDescriptor.getType().getConstructor().getDeclarationDescriptor();
        return object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
    }

    public static final KotlinTypeRefiner getKotlinTypeRefiner(ModuleDescriptor moduleDescriptor) {
        ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
        Intrinsics.checkNotNullParameter(moduleDescriptor2, "<this>");
        LazyJavaPackageScope$classes$1$$ExternalSyntheticThrowCCEIfNotNull0.m(moduleDescriptor2.getCapability(KotlinTypeRefinerKt.getREFINER_CAPABILITY()));
        return KotlinTypeRefiner$Default.INSTANCE;
    }

    public static final boolean isTypeRefinementEnabled(ModuleDescriptor moduleDescriptor) {
        ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
        Intrinsics.checkNotNullParameter(moduleDescriptor2, "<this>");
        LazyJavaPackageScope$classes$1$$ExternalSyntheticThrowCCEIfNotNull0.m(moduleDescriptor2.getCapability(KotlinTypeRefinerKt.getREFINER_CAPABILITY()));
        return false;
    }

    public static final InlineClassRepresentation getInlineClassRepresentation(ClassDescriptor object) {
        object = object != null ? object.getValueClassRepresentation() : null;
        return object instanceof InlineClassRepresentation ? (InlineClassRepresentation)object : null;
    }

    static {
        Name name = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(\"value\")");
        RETENTION_PARAMETER_NAME = name;
    }
}

