/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.OutputStream;
import java.util.ArrayList;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.LiteralByteString;

public final class ByteString$Output
extends OutputStream {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final int initialCapacity;
    private final ArrayList flushedBuffers;
    private int flushedBuffersTotalBytes;
    private byte[] buffer;
    private int bufferPos;

    ByteString$Output(int n) {
        if (n >= 0) {
            ByteString$Output byteString$Output = this;
            byteString$Output.initialCapacity = n;
            byteString$Output.flushedBuffers = new ArrayList();
            this.buffer = new byte[n];
            return;
        }
        throw new IllegalArgumentException("Buffer size < 0");
    }

    private byte[] copyArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        Object object = byArray2;
        int n2 = Math.min(byArray.length, n);
        System.arraycopy(byArray, 0, object, 0, n2);
        return byArray2;
    }

    private void flushFullBuffer(int n) {
        int n2;
        ByteString$Output byteString$Output = this;
        byteString$Output.flushedBuffers.add(new LiteralByteString(this.buffer));
        byteString$Output.flushedBuffersTotalBytes = n2 = byteString$Output.flushedBuffersTotalBytes + this.buffer.length;
        byteString$Output.buffer = new byte[Math.max(byteString$Output.initialCapacity, Math.max(n, n2 >>> 1))];
        byteString$Output.bufferPos = 0;
    }

    private void flushLastBuffer() {
        int n = this.bufferPos;
        byte[] byArray = this.buffer;
        if (n < this.buffer.length) {
            if (n > 0) {
                ByteString$Output byteString$Output = this;
                byte[] byArray2 = byteString$Output.copyArray(byArray, n);
                byteString$Output.flushedBuffers.add(new LiteralByteString(byArray2));
            }
        } else {
            this.flushedBuffers.add(new LiteralByteString(this.buffer));
            this.buffer = EMPTY_BYTE_ARRAY;
        }
        this.flushedBuffersTotalBytes += this.bufferPos;
        this.bufferPos = 0;
    }

    @Override
    public synchronized void write(int n) {
        if (this.bufferPos == this.buffer.length) {
            this.flushFullBuffer(1);
        }
        int n2 = this.bufferPos;
        this.bufferPos = n2 + 1;
        this.buffer[n2] = (byte)n;
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.buffer;
        int n3 = this.bufferPos;
        if (n2 <= this.buffer.length - n3) {
            System.arraycopy(byArray, n, byArray2, n3, n2);
            this.bufferPos += n2;
        } else {
            ByteString$Output byteString$Output = this;
            int n4 = byArray2.length - n3;
            System.arraycopy(byArray, n, byArray2, n3, n4);
            int n5 = n + n4;
            n4 = n2 - n4;
            byteString$Output.flushFullBuffer(n4);
            System.arraycopy(byArray, n5, byteString$Output.buffer, 0, n4);
            this.bufferPos = n4;
        }
    }

    public synchronized ByteString toByteString() {
        ByteString$Output byteString$Output = this;
        byteString$Output.flushLastBuffer();
        return ByteString.copyFrom(byteString$Output.flushedBuffers);
    }

    public synchronized int size() {
        return this.flushedBuffersTotalBytes + this.bufferPos;
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = Integer.toHexString(System.identityHashCode(this));
        objectArray[1] = this.size();
        return String.format("<ByteString.Output@%s size=%d>", objectArray2);
    }
}

