/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.Name;

public final class SpecialNames {
    public static final SpecialNames INSTANCE = new SpecialNames();
    public static final Name NO_NAME_PROVIDED;
    public static final Name ROOT_PACKAGE;
    public static final Name DEFAULT_NAME_FOR_COMPANION_OBJECT;
    public static final Name SAFE_IDENTIFIER_FOR_NO_NAME;
    public static final Name ANONYMOUS;
    public static final Name UNARY;
    public static final Name THIS;
    public static final Name INIT;
    public static final Name ITERATOR;
    public static final Name DESTRUCT;
    public static final Name LOCAL;
    public static final Name UNDERSCORE_FOR_UNUSED_VAR;
    public static final Name IMPLICIT_SET_PARAMETER;

    private SpecialNames() {
    }

    public static final Name safeIdentifier(Name name) {
        if (name == null || name.isSpecial()) {
            name = SAFE_IDENTIFIER_FOR_NO_NAME;
        }
        return name;
    }

    static {
        Name name = Name.special("<no name provided>");
        Intrinsics.checkNotNullExpressionValue(name, "special(\"<no name provided>\")");
        NO_NAME_PROVIDED = name;
        Name name2 = Name.special("<root package>");
        Intrinsics.checkNotNullExpressionValue(name2, "special(\"<root package>\")");
        ROOT_PACKAGE = name2;
        Name name3 = Name.identifier("Companion");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(\"Companion\")");
        DEFAULT_NAME_FOR_COMPANION_OBJECT = name3;
        Name name4 = Name.identifier("no_name_in_PSI_3d19d79d_1ba9_4cd0_b7f5_b46aa3cd5d40");
        Intrinsics.checkNotNullExpressionValue(name4, "identifier(\"no_name_in_P\u2026_4cd0_b7f5_b46aa3cd5d40\")");
        SAFE_IDENTIFIER_FOR_NO_NAME = name4;
        Name name5 = Name.special("<anonymous>");
        Intrinsics.checkNotNullExpressionValue(name5, "special(ANONYMOUS_STRING)");
        ANONYMOUS = name5;
        Name name6 = Name.special("<unary>");
        Intrinsics.checkNotNullExpressionValue(name6, "special(\"<unary>\")");
        UNARY = name6;
        Name name7 = Name.special("<this>");
        Intrinsics.checkNotNullExpressionValue(name7, "special(\"<this>\")");
        THIS = name7;
        Name name8 = Name.special("<init>");
        Intrinsics.checkNotNullExpressionValue(name8, "special(\"<init>\")");
        INIT = name8;
        Name name9 = Name.special("<iterator>");
        Intrinsics.checkNotNullExpressionValue(name9, "special(\"<iterator>\")");
        ITERATOR = name9;
        Name name10 = Name.special("<destruct>");
        Intrinsics.checkNotNullExpressionValue(name10, "special(\"<destruct>\")");
        DESTRUCT = name10;
        Name name11 = Name.special("<local>");
        Intrinsics.checkNotNullExpressionValue(name11, "special(\"<local>\")");
        LOCAL = name11;
        Name name12 = Name.special("<unused var>");
        Intrinsics.checkNotNullExpressionValue(name12, "special(\"<unused var>\")");
        UNDERSCORE_FOR_UNUSED_VAR = name12;
        Name name13 = Name.special("<set-?>");
        Intrinsics.checkNotNullExpressionValue(name13, "special(\"<set-?>\")");
        IMPLICIT_SET_PARAMETER = name13;
    }

    public final boolean isSafeIdentifier(Name name) {
        Name name2 = name;
        Intrinsics.checkNotNullParameter(name2, "name");
        String string = name2.asString();
        Intrinsics.checkNotNullExpressionValue(string, "name.asString()");
        return string.length() > 0 && !name.isSpecial();
    }
}

