/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType$Array;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType$Object;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType$Primitive;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactoryImpl$WhenMappings;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;

final class JvmTypeFactoryImpl
implements JvmTypeFactory {
    public static final JvmTypeFactoryImpl INSTANCE = new JvmTypeFactoryImpl();

    private JvmTypeFactoryImpl() {
    }

    public JvmType boxType(JvmType jvmType) {
        JvmType$Primitive jvmType$Primitive;
        JvmType jvmType2 = jvmType;
        Intrinsics.checkNotNullParameter(jvmType2, "possiblyPrimitiveType");
        if (jvmType2 instanceof JvmType$Primitive && (jvmType$Primitive = (JvmType$Primitive)jvmType).getJvmPrimitiveType() != null) {
            String string = JvmClassName.byFqNameWithoutInnerClasses(jvmType$Primitive.getJvmPrimitiveType().getWrapperFqName()).getInternalName();
            Intrinsics.checkNotNullExpressionValue(string, "byFqNameWithoutInnerClas\u2026apperFqName).internalName");
            jvmType = this.createObjectType(string);
        }
        return jvmType;
    }

    @Override
    public JvmType createFromString(String string) {
        Object object;
        JvmPrimitiveType jvmPrimitiveType2;
        char c;
        block9: {
            String string2 = string;
            Intrinsics.checkNotNullParameter(string2, "representation");
            c = string2.length() > 0 ? (char)'\u0001' : '\u0000';
            if (_Assertions.ENABLED && c == '\u0000') {
                throw new AssertionError((Object)"empty string as JvmType");
            }
            c = string.charAt(0);
            for (JvmPrimitiveType jvmPrimitiveType2 : JvmPrimitiveType.values()) {
                if (!(jvmPrimitiveType2.getDesc().charAt(0) == c)) {
                    continue;
                }
                break block9;
            }
            jvmPrimitiveType2 = null;
        }
        if (jvmPrimitiveType2 != null) {
            return new JvmType$Primitive(jvmPrimitiveType2);
        }
        if (c == 'V') {
            JvmType$Primitive jvmType$Primitive;
            object = jvmType$Primitive;
            jvmType$Primitive = new JvmType$Primitive(null);
        } else if (c == '[') {
            JvmType$Array jvmType$Array;
            JvmType$Array jvmType$Array2 = jvmType$Array;
            String string3 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
            jvmType$Array = new JvmType$Array(((JvmTypeFactoryImpl)object).createFromString(string3));
            object = jvmType$Array2;
        } else {
            JvmType$Object jvmType$Object;
            boolean bl = c == 'L' && StringsKt.endsWith$default((CharSequence)string, ';', false, 2, null);
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Type that is not primitive nor array should be Object, but '" + string + "' was found";
                throw new AssertionError((Object)string4);
            }
            object = jvmType$Object;
            String string5 = string;
            String string6 = string5.substring(1, string5.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string6, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            jvmType$Object = new JvmType$Object(string6);
        }
        return object;
    }

    @Override
    public JvmType createPrimitiveType(PrimitiveType primitiveType) {
        JvmType$Primitive jvmType$Primitive;
        Intrinsics.checkNotNullParameter((Object)primitiveType, "primitiveType");
        switch (JvmTypeFactoryImpl$WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()]) {
            default: {
                throw new NoWhenBranchMatchedException();
            }
            case 8: {
                jvmType$Primitive = JvmType.Companion.getDOUBLE$descriptors_jvm();
                break;
            }
            case 7: {
                jvmType$Primitive = JvmType.Companion.getLONG$descriptors_jvm();
                break;
            }
            case 6: {
                jvmType$Primitive = JvmType.Companion.getFLOAT$descriptors_jvm();
                break;
            }
            case 5: {
                jvmType$Primitive = JvmType.Companion.getINT$descriptors_jvm();
                break;
            }
            case 4: {
                jvmType$Primitive = JvmType.Companion.getSHORT$descriptors_jvm();
                break;
            }
            case 3: {
                jvmType$Primitive = JvmType.Companion.getBYTE$descriptors_jvm();
                break;
            }
            case 2: {
                jvmType$Primitive = JvmType.Companion.getCHAR$descriptors_jvm();
                break;
            }
            case 1: {
                jvmType$Primitive = JvmType.Companion.getBOOLEAN$descriptors_jvm();
            }
        }
        return jvmType$Primitive;
    }

    @Override
    public JvmType$Object createObjectType(String string) {
        Intrinsics.checkNotNullParameter(string, "internalName");
        return new JvmType$Object(string);
    }

    public String toString(JvmType jvmType) {
        block8: {
            block6: {
                Object object;
                block7: {
                    block5: {
                        JvmType jvmType2 = jvmType;
                        Intrinsics.checkNotNullParameter(jvmType2, "type");
                        if (!(jvmType2 instanceof JvmType$Array)) break block5;
                        object = '[' + object.toString(((JvmType$Array)jvmType).getElementType());
                        break block6;
                    }
                    if (!(jvmType instanceof JvmType$Primitive)) break block7;
                    object = ((JvmType$Primitive)jvmType).getJvmPrimitiveType();
                    if (object == null || (object = ((JvmPrimitiveType)((Object)object)).getDesc()) == null) {
                        object = "V";
                    }
                    break block6;
                }
                if (!(jvmType instanceof JvmType$Object)) break block8;
                object = 'L' + ((JvmType$Object)jvmType).getInternalName() + ';';
            }
            return object;
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    public JvmType getJavaLangClassType() {
        return this.createObjectType("java/lang/Class");
    }
}

