/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.load.kotlin.BinaryClassAnnotationAndConstantLoaderImpl$loadAnnotation$1;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass$AnnotationArgumentVisitor;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Annotation;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UIntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ULongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UShortValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.text.StringsKt;

public final class BinaryClassAnnotationAndConstantLoaderImpl
extends AbstractBinaryClassAnnotationAndConstantLoader {
    private final ModuleDescriptor module;
    private final NotFoundClasses notFoundClasses;
    private final AnnotationDeserializer annotationDeserializer;

    public BinaryClassAnnotationAndConstantLoaderImpl(ModuleDescriptor moduleDescriptor, NotFoundClasses notFoundClasses, StorageManager storageManager, KotlinClassFinder kotlinClassFinder) {
        AnnotationDeserializer annotationDeserializer;
        Intrinsics.checkNotNullParameter(moduleDescriptor, "module");
        Intrinsics.checkNotNullParameter(notFoundClasses, "notFoundClasses");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        Intrinsics.checkNotNullParameter(kotlinClassFinder, "kotlinClassFinder");
        super(storageManager, kotlinClassFinder);
        ((BinaryClassAnnotationAndConstantLoaderImpl)((Object)annotationDeserializer2)).module = moduleDescriptor;
        ((BinaryClassAnnotationAndConstantLoaderImpl)((Object)annotationDeserializer2)).notFoundClasses = notFoundClasses;
        AnnotationDeserializer annotationDeserializer2 = annotationDeserializer;
        annotationDeserializer = new AnnotationDeserializer(moduleDescriptor, notFoundClasses);
        v1.annotationDeserializer = annotationDeserializer2;
    }

    private final ConstantValue createConstant(Name name, Object object) {
        Object object2 = ConstantValueFactory.INSTANCE.createConstantValue(object);
        if (object2 == null) {
            object2 = ErrorValue.Companion.create("Unsupported annotation argument: " + name);
        }
        return object2;
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }

    public static final /* synthetic */ ConstantValue access$createConstant(BinaryClassAnnotationAndConstantLoaderImpl binaryClassAnnotationAndConstantLoaderImpl, Name name, Object object) {
        return binaryClassAnnotationAndConstantLoaderImpl.createConstant(name, object);
    }

    @Override
    protected AnnotationDescriptor loadTypeAnnotation(ProtoBuf$Annotation protoBuf$Annotation, NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter(protoBuf$Annotation, "proto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        return this.annotationDeserializer.deserializeAnnotation(protoBuf$Annotation, nameResolver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected ConstantValue loadConstant(String string, Object object) {
        Intrinsics.checkNotNullParameter(string, "desc");
        Intrinsics.checkNotNullParameter(object, "initializer");
        if (!StringsKt.contains$default((CharSequence)"ZBCS", string, false, 2, null)) return ConstantValueFactory.INSTANCE.createConstantValue(object);
        int n = (Integer)object;
        int n2 = string.hashCode();
        if (n2 != 66) {
            if (n2 != 67) {
                if (n2 != 83) {
                    if (n2 != 90 || !string.equals("Z")) throw new AssertionError((Object)string);
                    object = n != 0;
                    return ConstantValueFactory.INSTANCE.createConstantValue(object);
                } else {
                    if (!string.equals("S")) throw new AssertionError((Object)string);
                    object = (short)n;
                }
                return ConstantValueFactory.INSTANCE.createConstantValue(object);
            } else {
                if (!string.equals("C")) throw new AssertionError((Object)string);
                object = Character.valueOf((char)n);
            }
            return ConstantValueFactory.INSTANCE.createConstantValue(object);
        } else {
            if (!string.equals("B")) throw new AssertionError((Object)string);
            object = (byte)n;
        }
        return ConstantValueFactory.INSTANCE.createConstantValue(object);
    }

    protected ConstantValue transformToUnsignedConstant(ConstantValue object) {
        Object object2;
        ConstantValue constantValue = object;
        Intrinsics.checkNotNullParameter(constantValue, "constant");
        if (constantValue instanceof ByteValue) {
            UByteValue uByteValue;
            object2 = uByteValue;
            uByteValue = new UByteValue(((Number)((ByteValue)object).getValue()).byteValue());
            object = object2;
        } else if (object instanceof ShortValue) {
            UShortValue uShortValue;
            object2 = uShortValue;
            uShortValue = new UShortValue(((Number)((ShortValue)object).getValue()).shortValue());
            object = object2;
        } else if (object instanceof IntValue) {
            UIntValue uIntValue;
            object2 = uIntValue;
            uIntValue = new UIntValue(((Number)((IntValue)object).getValue()).intValue());
            object = object2;
        } else if (object instanceof LongValue) {
            ULongValue uLongValue;
            object2 = uLongValue;
            uLongValue = new ULongValue(((Number)((LongValue)object).getValue()).longValue());
            object = object2;
        }
        return object;
    }

    @Override
    protected KotlinJvmBinaryClass$AnnotationArgumentVisitor loadAnnotation(ClassId classId, SourceElement sourceElement, List list) {
        Intrinsics.checkNotNullParameter(classId, "annotationClassId");
        Intrinsics.checkNotNullParameter(sourceElement, "source");
        Intrinsics.checkNotNullParameter(list, "result");
        ClassDescriptor classDescriptor = this.resolveClass(classId);
        return new BinaryClassAnnotationAndConstantLoaderImpl$loadAnnotation$1(this, classDescriptor, classId, list, sourceElement);
    }
}

