/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaMember;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaConstructor;

public final class ReflectJavaConstructor
extends ReflectJavaMember
implements JavaConstructor {
    private final Constructor member;

    public ReflectJavaConstructor(Constructor constructor) {
        Intrinsics.checkNotNullParameter(constructor, "member");
        this.member = constructor;
    }

    @Override
    public Constructor getMember() {
        return this.member;
    }

    @Override
    public List getValueParameters() {
        Object[] objectArray = this.getMember().getGenericParameterTypes();
        Intrinsics.checkNotNullExpressionValue(objectArray, "types");
        if (objectArray.length == 0) {
            return CollectionsKt.emptyList();
        }
        Annotation[][] annotationArray = this.getMember().getDeclaringClass();
        if (annotationArray.getDeclaringClass() != null && !Modifier.isStatic(annotationArray.getModifiers())) {
            objectArray = (Type[])ArraysKt.copyOfRange(objectArray, 1, objectArray.length);
        }
        if ((annotationArray = this.getMember().getParameterAnnotations()).length >= objectArray.length) {
            if (annotationArray.length > objectArray.length) {
                Annotation[][] annotationArray2 = annotationArray;
                Intrinsics.checkNotNullExpressionValue(annotationArray2, "annotations");
                int n = annotationArray.length - objectArray.length;
                annotationArray = (Annotation[][])ArraysKt.copyOfRange((Object[])annotationArray, n, annotationArray2.length);
            }
            Intrinsics.checkNotNullExpressionValue(objectArray, "realTypes");
            Intrinsics.checkNotNullExpressionValue(annotationArray, "realAnnotations");
            return this.getValueParameters((Type[])objectArray, annotationArray, this.getMember().isVarArgs());
        }
        throw new IllegalStateException("Illegal generic signature: " + this.getMember());
    }

    @Override
    public List getTypeParameters() {
        ArrayList<ReflectJavaTypeParameter> arrayList;
        TypeVariable<Constructor<T>>[] typeVariableArray = typeVariableArray.getMember().getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, "member.typeParameters");
        ArrayList<ReflectJavaTypeParameter> arrayList2 = arrayList;
        arrayList = new ArrayList<ReflectJavaTypeParameter>(typeVariableArray.length);
        for (TypeVariable typeVariable : typeVariableArray) {
            ReflectJavaTypeParameter reflectJavaTypeParameter;
            ReflectJavaTypeParameter reflectJavaTypeParameter2 = reflectJavaTypeParameter;
            reflectJavaTypeParameter = new ReflectJavaTypeParameter(typeVariable);
            arrayList2.add(reflectJavaTypeParameter2);
        }
        return arrayList2;
    }
}

