/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedArrayType;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedType;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;

public final class UnsignedTypes {
    public static final UnsignedTypes INSTANCE;
    private static final Set unsignedTypeNames;
    private static final Set unsignedArrayTypeNames;
    private static final HashMap arrayClassIdToUnsignedClassId;
    private static final HashMap unsignedClassIdToArrayClassId;
    private static final HashMap unsignedArrayTypeToArrayCall;
    private static final Set arrayClassesShortNames;

    private UnsignedTypes() {
    }

    public static final boolean isUnsignedType(KotlinType annotated) {
        KotlinType kotlinType = annotated;
        Intrinsics.checkNotNullParameter(kotlinType, "type");
        if (TypeUtils.noExpectedType(kotlinType)) {
            return false;
        }
        if ((annotated = annotated.getConstructor().getDeclarationDescriptor()) == null) {
            return false;
        }
        return INSTANCE.isUnsignedClass((DeclarationDescriptor)annotated);
    }

    static {
        LinkedHashSet linkedHashSet;
        ArrayList<Name> arrayList;
        int n;
        ArrayList<Name> arrayList2;
        INSTANCE = new UnsignedTypes();
        Enum[] enumArray = UnsignedType.values();
        AbstractCollection abstractCollection = arrayList2;
        arrayList2 = new ArrayList<Name>(enumArray.length);
        int n2 = enumArray.length;
        for (n = 0; n < n2; ++n) {
            abstractCollection.add(enumArray[n].getTypeName());
        }
        unsignedTypeNames = CollectionsKt.toSet(abstractCollection);
        enumArray = UnsignedArrayType.values();
        abstractCollection = arrayList;
        arrayList = new ArrayList<Name>(enumArray.length);
        int object = enumArray.length;
        for (n = 0; n < object; ++n) {
            abstractCollection.add(((UnsignedArrayType)enumArray[n]).getTypeName());
        }
        unsignedArrayTypeNames = CollectionsKt.toSet(abstractCollection);
        arrayClassIdToUnsignedClassId = new HashMap();
        unsignedClassIdToArrayClassId = new HashMap();
        unsignedArrayTypeToArrayCall = MapsKt.hashMapOf(TuplesKt.to((Object)UnsignedArrayType.UBYTEARRAY, Name.identifier("ubyteArrayOf")), TuplesKt.to((Object)UnsignedArrayType.USHORTARRAY, Name.identifier("ushortArrayOf")), TuplesKt.to((Object)UnsignedArrayType.UINTARRAY, Name.identifier("uintArrayOf")), TuplesKt.to((Object)UnsignedArrayType.ULONGARRAY, Name.identifier("ulongArrayOf")));
        enumArray = UnsignedType.values();
        abstractCollection = linkedHashSet;
        linkedHashSet = new LinkedHashSet();
        int n3 = enumArray.length;
        for (n = 0; n < n3; ++n) {
            abstractCollection.add(((UnsignedType)enumArray[n]).getArrayClassId().getShortClassName());
        }
        arrayClassesShortNames = abstractCollection;
        enumArray = UnsignedType.values();
        n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            Enum enum_;
            Enum enum_2 = enum_ = enumArray[i];
            ClassId classId = ((UnsignedType)enum_2).getArrayClassId();
            arrayClassIdToUnsignedClassId.put(classId, ((UnsignedType)enum_2).getClassId());
            Enum enum_3 = enum_;
            ClassId classId2 = ((UnsignedType)enum_3).getClassId();
            unsignedClassIdToArrayClassId.put(classId2, ((UnsignedType)enum_3).getArrayClassId());
        }
    }

    public final boolean isShortNameOfUnsignedArray(Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return arrayClassesShortNames.contains(name);
    }

    public final ClassId getUnsignedClassIdByArrayClassId(ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "arrayClassId");
        return (ClassId)arrayClassIdToUnsignedClassId.get(classId);
    }

    public final boolean isUnsignedClass(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        Intrinsics.checkNotNullParameter(declarationDescriptor2, "descriptor");
        DeclarationDescriptor declarationDescriptor3 = declarationDescriptor2.getContainingDeclaration();
        return declarationDescriptor3 instanceof PackageFragmentDescriptor && Intrinsics.areEqual(((PackageFragmentDescriptor)declarationDescriptor3).getFqName(), StandardNames.BUILT_INS_PACKAGE_FQ_NAME) && unsignedTypeNames.contains(declarationDescriptor.getName());
    }
}

