/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.KCallableImpl;
import kotlin.reflect.jvm.internal.KDeclarationContainerImpl;
import kotlin.reflect.jvm.internal.KFunctionImpl;
import kotlin.reflect.jvm.internal.KMutableProperty0Impl;
import kotlin.reflect.jvm.internal.KMutableProperty1Impl;
import kotlin.reflect.jvm.internal.KMutableProperty2Impl;
import kotlin.reflect.jvm.internal.KProperty0Impl;
import kotlin.reflect.jvm.internal.KProperty1Impl;
import kotlin.reflect.jvm.internal.KProperty2Impl;
import kotlin.reflect.jvm.internal.KotlinReflectionInternalError;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.DeclarationDescriptorVisitorEmptyBodies;

public class CreateKCallableVisitor
extends DeclarationDescriptorVisitorEmptyBodies {
    private final KDeclarationContainerImpl container;

    public CreateKCallableVisitor(KDeclarationContainerImpl kDeclarationContainerImpl) {
        Intrinsics.checkNotNullParameter(kDeclarationContainerImpl, "container");
        this.container = kDeclarationContainerImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KCallableImpl visitPropertyDescriptor(PropertyDescriptor propertyDescriptor, Unit unit) {
        Intrinsics.checkNotNullParameter(propertyDescriptor, "descriptor");
        Intrinsics.checkNotNullParameter(unit, "data");
        int n = propertyDescriptor.getDispatchReceiverParameter() != null ? 1 : 0;
        int n2 = propertyDescriptor.getExtensionReceiverParameter() != null ? 1 : 0;
        n += n2;
        if (propertyDescriptor.isVar()) {
            if (n == 0) return new KMutableProperty0Impl(this.container, propertyDescriptor);
            if (n == 1) return new KMutableProperty1Impl(this.container, propertyDescriptor);
            if (n != 2) throw new KotlinReflectionInternalError("Unsupported property: " + propertyDescriptor);
            return new KMutableProperty2Impl(this.container, propertyDescriptor);
        }
        if (n == 0) return new KProperty0Impl(this.container, propertyDescriptor);
        if (n == 1) return new KProperty1Impl(this.container, propertyDescriptor);
        if (n != 2) throw new KotlinReflectionInternalError("Unsupported property: " + propertyDescriptor);
        return new KProperty2Impl(this.container, propertyDescriptor);
    }

    public KCallableImpl visitFunctionDescriptor(FunctionDescriptor functionDescriptor, Unit unit) {
        Intrinsics.checkNotNullParameter(functionDescriptor, "descriptor");
        Intrinsics.checkNotNullParameter(unit, "data");
        return new KFunctionImpl(this.container, functionDescriptor);
    }
}

