/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.reflect.KMutableProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.reflect.jvm.internal.KCallableImpl;
import kotlin.reflect.jvm.internal.KPropertyImpl;
import kotlin.reflect.jvm.internal.KTypeImpl;
import kotlin.reflect.jvm.internal.UtilKt;

public abstract class ReflectJvmMapping {
    public static final Field getJavaField(KProperty kProperty) {
        KProperty kProperty2 = kProperty;
        Intrinsics.checkNotNullParameter(kProperty2, "<this>");
        kProperty = UtilKt.asKPropertyImpl(kProperty2);
        return kProperty != null ? ((KPropertyImpl)kProperty).getJavaField() : null;
    }

    public static final Method getJavaGetter(KProperty kProperty) {
        KProperty kProperty2 = kProperty;
        Intrinsics.checkNotNullParameter(kProperty2, "<this>");
        return ReflectJvmMapping.getJavaMethod(kProperty2.getGetter());
    }

    public static final Method getJavaSetter(KMutableProperty kMutableProperty) {
        KMutableProperty kMutableProperty2 = kMutableProperty;
        Intrinsics.checkNotNullParameter(kMutableProperty2, "<this>");
        return ReflectJvmMapping.getJavaMethod(kMutableProperty2.getSetter());
    }

    public static final Method getJavaMethod(KFunction object) {
        KFunction kFunction = object;
        Intrinsics.checkNotNullParameter(kFunction, "<this>");
        object = UtilKt.asKCallableImpl(kFunction);
        object = object != null && (object = ((KCallableImpl)object).getCaller()) != null ? object.getMember() : null;
        return object instanceof Method ? (Method)object : null;
    }

    public static final Constructor getJavaConstructor(KFunction object) {
        KFunction kFunction = object;
        Intrinsics.checkNotNullParameter(kFunction, "<this>");
        object = UtilKt.asKCallableImpl(kFunction);
        object = object != null && (object = ((KCallableImpl)object).getCaller()) != null ? object.getMember() : null;
        return object instanceof Constructor ? (Constructor)object : null;
    }

    public static final Type getJavaType(KType kType) {
        KType kType2 = kType;
        Intrinsics.checkNotNullParameter(kType2, "<this>");
        Type type2 = ((KTypeImpl)kType2).getJavaType();
        if (type2 == null) {
            type2 = TypesJVMKt.getJavaType(kType);
        }
        return type2;
    }
}

