/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;

final class ArrayIterator
implements Iterator,
KMappedMarker {
    private final Object[] array;
    private int index;

    public ArrayIterator(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "array");
        this.array = objectArray;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.array.length;
    }

    public Object next() {
        int n;
        Object[] objectArray;
        try {
            objectArray = this.array;
            ArrayIterator arrayIterator = this;
            ArrayIterator arrayIterator2 = arrayIterator;
            n = arrayIterator.index;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            --this.index;
            throw new NoSuchElementException(arrayIndexOutOfBoundsException.getMessage());
        }
        arrayIterator2.index = n + 1;
        return objectArray[n];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

