/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.EmptyMap;
import kotlin.collections.MapsKt;
import kotlin.collections.MapsKt__MapWithDefaultKt;
import kotlin.collections.MapsKt__MapsJVMKt;
import kotlin.jvm.internal.Intrinsics;

abstract class MapsKt__MapsKt
extends MapsKt__MapsJVMKt {
    public static Map emptyMap() {
        EmptyMap emptyMap = EmptyMap.INSTANCE;
        Intrinsics.checkNotNull(emptyMap, "null cannot be cast to non-null type kotlin.collections.Map<K of kotlin.collections.MapsKt__MapsKt.emptyMap, V of kotlin.collections.MapsKt__MapsKt.emptyMap>");
        return emptyMap;
    }

    public static Map mapOf(Pair ... pairArray) {
        Intrinsics.checkNotNullParameter(pairArray, "pairs");
        return pairArray.length > 0 ? MapsKt__MapsKt.toMap(pairArray, new LinkedHashMap(MapsKt.mapCapacity(pairArray.length))) : MapsKt.emptyMap();
    }

    public static Map mutableMapOf(Pair ... pairArray) {
        Intrinsics.checkNotNullParameter(pairArray, "pairs");
        LinkedHashMap linkedHashMap = new LinkedHashMap(MapsKt.mapCapacity(pairArray.length));
        MapsKt__MapsKt.putAll(linkedHashMap, pairArray);
        return linkedHashMap;
    }

    public static HashMap hashMapOf(Pair ... pairArray) {
        Intrinsics.checkNotNullParameter(pairArray, "pairs");
        HashMap hashMap = new HashMap(MapsKt.mapCapacity(pairArray.length));
        MapsKt__MapsKt.putAll(hashMap, pairArray);
        return hashMap;
    }

    public static Object getValue(Map map, Object object) {
        Intrinsics.checkNotNullParameter(map, "<this>");
        return MapsKt__MapWithDefaultKt.getOrImplicitDefaultNullable(map, object);
    }

    public static final void putAll(Map map, Pair[] pairArray) {
        Intrinsics.checkNotNullParameter(map, "<this>");
        Intrinsics.checkNotNullParameter(pairArray, "pairs");
        for (Pair pair : pairArray) {
            Object object = pair.component1();
            map.put(object, pair.component2());
        }
    }

    public static void putAll(Map map, Iterable object) {
        Iterable iterable = object;
        Intrinsics.checkNotNullParameter(map, "<this>");
        Intrinsics.checkNotNullParameter(iterable, "pairs");
        for (Pair pair : iterable) {
            Object object2 = pair.component1();
            map.put(object2, pair.component2());
        }
    }

    public static Map toMap(Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof Collection) {
            Collection collection = (Collection)iterable;
            int n = collection.size();
            return n != 0 ? (n != 1 ? MapsKt.toMap(iterable, new LinkedHashMap(MapsKt.mapCapacity(collection.size()))) : MapsKt.mapOf(iterable instanceof List ? (Pair)((List)iterable).get(0) : (Pair)iterable.iterator().next())) : MapsKt.emptyMap();
        }
        return MapsKt__MapsKt.optimizeReadOnlyMap(MapsKt.toMap(iterable, new LinkedHashMap()));
    }

    public static Map toMap(Iterable iterable, Map map) {
        Map map2 = map;
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        Intrinsics.checkNotNullParameter(map2, "destination");
        MapsKt.putAll(map2, iterable);
        return map2;
    }

    public static final Map toMap(Pair[] pairArray, Map map) {
        Map map2 = map;
        Intrinsics.checkNotNullParameter(pairArray, "<this>");
        Intrinsics.checkNotNullParameter(map2, "destination");
        MapsKt__MapsKt.putAll(map2, pairArray);
        return map2;
    }

    public static Map toMap(Map map) {
        Map map2 = map;
        Intrinsics.checkNotNullParameter(map2, "<this>");
        int n = map2.size();
        return n != 0 ? (n != 1 ? MapsKt.toMutableMap(map) : MapsKt__MapsJVMKt.toSingletonMap(map)) : MapsKt.emptyMap();
    }

    public static Map toMutableMap(Map map) {
        Intrinsics.checkNotNullParameter(map, "<this>");
        return new LinkedHashMap(map);
    }

    public static Map plus(Map map, Map map2) {
        Intrinsics.checkNotNullParameter(map, "<this>");
        Intrinsics.checkNotNullParameter(map2, "map");
        LinkedHashMap linkedHashMap = new LinkedHashMap(map);
        linkedHashMap.putAll(map2);
        return linkedHashMap;
    }

    public static final Map optimizeReadOnlyMap(Map map) {
        Map map2 = map;
        Intrinsics.checkNotNullParameter(map2, "<this>");
        int n = map2.size();
        if (n != 0) {
            if (n == 1) {
                map = MapsKt__MapsJVMKt.toSingletonMap(map);
            }
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }
}

