/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.ArraysKt___ArraysJvmKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.CollectionsKt__MutableCollectionsKt;
import kotlin.collections.CollectionsKt___CollectionsJvmKt;
import kotlin.collections.CollectionsKt___CollectionsKt$asSequence$$inlined$Sequence$1;
import kotlin.collections.CollectionsKt___CollectionsKt$withIndex$1;
import kotlin.collections.IndexingIterable;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.collections.SetsKt__SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;

abstract class CollectionsKt___CollectionsKt
extends CollectionsKt___CollectionsJvmKt {
    public static boolean contains(Iterable iterable, Object object) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof Collection) {
            return ((Collection)iterable).contains(object);
        }
        return CollectionsKt___CollectionsKt.indexOf(iterable, object) >= 0;
    }

    public static Object first(Iterable object) {
        Iterable iterable = object;
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        if (iterable instanceof List) {
            return CollectionsKt.first((List)object);
        }
        if ((object = object.iterator()).hasNext()) {
            return object.next();
        }
        throw new NoSuchElementException("Collection is empty.");
    }

    public static Object first(List list) {
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        if (!list2.isEmpty()) {
            return list.get(0);
        }
        throw new NoSuchElementException("List is empty.");
    }

    public static Object firstOrNull(Iterable object) {
        Iterable iterable = object;
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        if (iterable instanceof List) {
            if ((object = (List)object).isEmpty()) {
                return null;
            }
            return object.get(0);
        }
        if (!(object = object.iterator()).hasNext()) {
            return null;
        }
        return object.next();
    }

    public static Object firstOrNull(List list) {
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        return list2.isEmpty() ? null : list.get(0);
    }

    public static Object getOrNull(List list, int n) {
        Intrinsics.checkNotNullParameter(list, "<this>");
        return n >= 0 && n <= CollectionsKt.getLastIndex(list) ? list.get(n) : null;
    }

    public static final int indexOf(Iterable iterable, Object object) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof List) {
            return ((List)iterable).indexOf(object);
        }
        int n = 0;
        for (Object t : iterable) {
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            if (Intrinsics.areEqual(object, t)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static Object last(Iterable object) {
        Iterable iterable = object;
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        if (iterable instanceof List) {
            return CollectionsKt.last((List)object);
        }
        if ((object = object.iterator()).hasNext()) {
            Object e = object.next();
            while (object.hasNext()) {
                e = object.next();
            }
            return e;
        }
        throw new NoSuchElementException("Collection is empty.");
    }

    public static Object last(List list) {
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        if (!list2.isEmpty()) {
            List list3 = list;
            return list3.get(CollectionsKt.getLastIndex(list3));
        }
        throw new NoSuchElementException("List is empty.");
    }

    public static Object lastOrNull(Iterable object) {
        Iterable iterable = object;
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        if (iterable instanceof List) {
            Object v1;
            if ((object = (List)object).isEmpty()) {
                v1 = null;
            } else {
                Object object2 = object;
                v1 = object2.get(object2.size() - 1);
            }
            return v1;
        }
        if (!(object = object.iterator()).hasNext()) {
            return null;
        }
        Object e = object.next();
        while (object.hasNext()) {
            e = object.next();
        }
        return e;
    }

    public static Object lastOrNull(List list) {
        Object v1;
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        if (list2.isEmpty()) {
            v1 = null;
        } else {
            List list3 = list;
            v1 = list3.get(list3.size() - 1);
        }
        return v1;
    }

    public static Object single(Iterable object) {
        Iterable iterable = object;
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        if (iterable instanceof List) {
            return CollectionsKt.single((List)object);
        }
        if ((object = object.iterator()).hasNext()) {
            Object object2 = object;
            object = object2.next();
            if (!object2.hasNext()) {
                return object;
            }
            throw new IllegalArgumentException("Collection has more than one element.");
        }
        throw new NoSuchElementException("Collection is empty.");
    }

    public static Object single(List list) {
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        int n = list2.size();
        if (n != 0) {
            if (n == 1) {
                return list.get(0);
            }
            throw new IllegalArgumentException("List has more than one element.");
        }
        throw new NoSuchElementException("List is empty.");
    }

    public static Object singleOrNull(Iterable object) {
        Iterable iterable = object;
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        if (iterable instanceof List) {
            return (object = (List)object).size() == 1 ? object.get(0) : null;
        }
        if (!(object = object.iterator()).hasNext()) {
            return null;
        }
        Object object2 = object;
        object = object2.next();
        if (object2.hasNext()) {
            return null;
        }
        return object;
    }

    public static Object singleOrNull(List list) {
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        return list2.size() == 1 ? list.get(0) : null;
    }

    public static List drop(Iterable listIterator, int n) {
        Intrinsics.checkNotNullParameter(listIterator, "<this>");
        if (n >= 0) {
            ArrayList arrayList;
            Object object;
            if (n == 0) {
                return CollectionsKt.toList((Iterable)((Object)listIterator));
            }
            if (listIterator instanceof Collection) {
                ArrayList arrayList2;
                object = (Collection)((Object)listIterator);
                int n2 = object.size() - n;
                if (n2 <= 0) {
                    return CollectionsKt.emptyList();
                }
                if (n2 == 1) {
                    return CollectionsKt.listOf(CollectionsKt.last((Iterable)((Object)listIterator)));
                }
                arrayList = arrayList2;
                arrayList2 = new ArrayList(n2);
                if (listIterator instanceof List) {
                    if (listIterator instanceof RandomAccess) {
                        int n3 = object.size();
                        while (n < n3) {
                            arrayList.add(((List)((Object)listIterator)).get(n));
                            ++n;
                        }
                    } else {
                        listIterator = ((List)((Object)listIterator)).listIterator(n);
                        while (listIterator.hasNext()) {
                            arrayList.add(listIterator.next());
                        }
                    }
                    return arrayList;
                }
            } else {
                ArrayList arrayList3;
                arrayList = arrayList3;
                arrayList3 = new ArrayList();
            }
            int n4 = 0;
            object = listIterator.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (n4 >= n) {
                    arrayList.add(e);
                    continue;
                }
                ++n4;
            }
            return CollectionsKt.optimizeReadOnlyList(arrayList);
        }
        listIterator = "Requested element count " + n + " is less than zero.";
        throw new IllegalArgumentException(listIterator.toString());
    }

    public static List dropLast(List object, int n) {
        Intrinsics.checkNotNullParameter(object, "<this>");
        if (n >= 0) {
            List list = object;
            return CollectionsKt___CollectionsKt.take(list, RangesKt.coerceAtLeast(list.size() - n, 0));
        }
        object = "Requested element count " + n + " is less than zero.";
        throw new IllegalArgumentException(object.toString());
    }

    public static List filter(Iterable iterable, Function1 function1) {
        ArrayList arrayList;
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        Intrinsics.checkNotNullParameter(function1, "predicate");
        iterable = arrayList;
        arrayList = new ArrayList();
        for (Object t : iterable2) {
            if (!((Boolean)function1.invoke(t)).booleanValue()) continue;
            iterable.add(t);
        }
        return iterable;
    }

    public static final List take(Iterable object, int n) {
        Intrinsics.checkNotNullParameter(object, "<this>");
        if (n >= 0) {
            ArrayList arrayList;
            if (n == 0) {
                return CollectionsKt.emptyList();
            }
            if (object instanceof Collection) {
                if (n >= ((Collection)object).size()) {
                    return CollectionsKt.toList((Iterable)object);
                }
                if (n == 1) {
                    return CollectionsKt.listOf(CollectionsKt.first((Iterable)object));
                }
            }
            int n2 = 0;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList(n);
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                arrayList2.add(iterator2.next());
                if (++n2 != n) continue;
            }
            return CollectionsKt.optimizeReadOnlyList(arrayList2);
        }
        object = "Requested element count " + n + " is less than zero.";
        throw new IllegalArgumentException(object.toString());
    }

    public static List takeLast(List listIterator, int n) {
        Intrinsics.checkNotNullParameter(listIterator, "<this>");
        if (n >= 0) {
            ArrayList arrayList;
            if (n == 0) {
                return CollectionsKt.emptyList();
            }
            int n2 = listIterator.size();
            if (n >= n2) {
                return CollectionsKt.toList((Iterable)((Object)listIterator));
            }
            if (n == 1) {
                return CollectionsKt.listOf(CollectionsKt.last((List)((Object)listIterator)));
            }
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList(n);
            if (listIterator instanceof RandomAccess) {
                for (n = n2 - n; n < n2; ++n) {
                    arrayList2.add(listIterator.get(n));
                }
            } else {
                listIterator = listIterator.listIterator(n2 - n);
                while (listIterator.hasNext()) {
                    arrayList2.add(listIterator.next());
                }
            }
            return arrayList2;
        }
        listIterator = "Requested element count " + n + " is less than zero.";
        throw new IllegalArgumentException(listIterator.toString());
    }

    public static List sorted(Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof Collection) {
            Collection collection = (Collection)iterable;
            if (collection.size() <= 1) {
                return CollectionsKt.toList(iterable);
            }
            Object[] objectArray = collection.toArray(new Comparable[0]);
            Intrinsics.checkNotNull(objectArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            Intrinsics.checkNotNull(objectArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.CollectionsKt___CollectionsKt.sorted>");
            ArraysKt___ArraysJvmKt.sort(objectArray);
            return ArraysKt.asList(objectArray);
        }
        List list = CollectionsKt___CollectionsKt.toMutableList(iterable);
        CollectionsKt.sort(list);
        return list;
    }

    public static List sortedWith(Iterable iterable, Comparator comparator) {
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            if (collection.size() <= 1) {
                return CollectionsKt.toList(iterable);
            }
            Object[] objectArray = collection.toArray(new Object[0]);
            Intrinsics.checkNotNull(objectArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            Intrinsics.checkNotNull(objectArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.CollectionsKt___CollectionsKt.sortedWith>");
            ArraysKt___ArraysJvmKt.sortWith(objectArray, comparator);
            return ArraysKt.asList(objectArray);
        }
        List list = CollectionsKt___CollectionsKt.toMutableList(iterable);
        CollectionsKt.sortWith(list, comparator);
        return list;
    }

    public static int[] toIntArray(Collection object) {
        Collection collection = object;
        Intrinsics.checkNotNullParameter(collection, "<this>");
        object = new int[collection.size()];
        int n = 0;
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            int n2 = ((Number)iterator2.next()).intValue();
            object[n++] = n2;
        }
        return object;
    }

    public static final Collection toCollection(Iterable object, Collection collection) {
        Intrinsics.checkNotNullParameter(object, "<this>");
        Intrinsics.checkNotNullParameter(collection, "destination");
        object = object.iterator();
        while (object.hasNext()) {
            collection.add(object.next());
        }
        return collection;
    }

    public static final HashSet toHashSet(Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        return (HashSet)CollectionsKt___CollectionsKt.toCollection(iterable2, new HashSet(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault(iterable, 12))));
    }

    public static List toList(Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof Collection) {
            Collection collection = (Collection)iterable;
            int n = collection.size();
            return n != 0 ? (n != 1 ? CollectionsKt.toMutableList(collection) : CollectionsKt.listOf(iterable instanceof List ? ((List)iterable).get(0) : iterable.iterator().next())) : CollectionsKt.emptyList();
        }
        return CollectionsKt.optimizeReadOnlyList(CollectionsKt___CollectionsKt.toMutableList(iterable));
    }

    public static final List toMutableList(Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof Collection) {
            return CollectionsKt.toMutableList((Collection)iterable);
        }
        return (List)CollectionsKt___CollectionsKt.toCollection(iterable, new ArrayList());
    }

    public static List toMutableList(Collection collection) {
        Intrinsics.checkNotNullParameter(collection, "<this>");
        return new ArrayList(collection);
    }

    public static Set toSet(Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof Collection) {
            Collection collection = (Collection)iterable;
            int n = collection.size();
            return n != 0 ? (n != 1 ? (Set)CollectionsKt___CollectionsKt.toCollection(iterable, new LinkedHashSet(MapsKt.mapCapacity(collection.size()))) : SetsKt.setOf(iterable instanceof List ? ((List)iterable).get(0) : iterable.iterator().next())) : SetsKt.emptySet();
        }
        return SetsKt__SetsKt.optimizeReadOnlySet((Set)CollectionsKt___CollectionsKt.toCollection(iterable, new LinkedHashSet()));
    }

    public static List map(Iterable object, Function1 function1) {
        ArrayList<Object> arrayList;
        Intrinsics.checkNotNullParameter(object, "<this>");
        Intrinsics.checkNotNullParameter(function1, "transform");
        ArrayList<Object> arrayList2 = arrayList;
        arrayList = new ArrayList<Object>(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10));
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(function1.invoke(object.next()));
        }
        return arrayList2;
    }

    public static Iterable withIndex(Iterable iterable) {
        CollectionsKt___CollectionsKt$withIndex$1 collectionsKt___CollectionsKt$withIndex$1;
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        CollectionsKt___CollectionsKt$withIndex$1 collectionsKt___CollectionsKt$withIndex$12 = collectionsKt___CollectionsKt$withIndex$1;
        collectionsKt___CollectionsKt$withIndex$1 = new CollectionsKt___CollectionsKt$withIndex$1(iterable);
        return new IndexingIterable(collectionsKt___CollectionsKt$withIndex$12);
    }

    public static List distinct(Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        return CollectionsKt.toList(CollectionsKt.toMutableSet(iterable2));
    }

    public static Set intersect(Iterable iterable, Iterable iterable2) {
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        Intrinsics.checkNotNullParameter(iterable2, "other");
        Set set = CollectionsKt.toMutableSet(iterable);
        CollectionsKt__MutableCollectionsKt.retainAll(set, iterable2);
        return set;
    }

    public static Set toMutableSet(Iterable iterable) {
        Set set;
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof Collection) {
            LinkedHashSet linkedHashSet;
            set = linkedHashSet;
            linkedHashSet = new LinkedHashSet((Collection)iterable);
        } else {
            set = (Set)CollectionsKt___CollectionsKt.toCollection(iterable, new LinkedHashSet());
        }
        return set;
    }

    public static Set union(Iterable iterable, Iterable iterable2) {
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        Intrinsics.checkNotNullParameter(iterable2, "other");
        Set set = CollectionsKt.toMutableSet(iterable);
        CollectionsKt.addAll((Collection)set, iterable2);
        return set;
    }

    public static boolean all(Iterable object, Function1 function1) {
        Intrinsics.checkNotNullParameter(object, "<this>");
        Intrinsics.checkNotNullParameter(function1, "predicate");
        if (object instanceof Collection && ((Collection)object).isEmpty()) {
            return true;
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (((Boolean)function1.invoke(object.next())).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static List minus(Iterable iterable, Object object) {
        ArrayList arrayList;
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
        boolean bl = false;
        for (Object t : iterable2) {
            boolean bl2;
            if (!bl && Intrinsics.areEqual(t, object)) {
                bl = true;
                bl2 = false;
            } else {
                bl2 = true;
            }
            if (!bl2) continue;
            arrayList2.add(t);
        }
        return arrayList2;
    }

    public static List plus(Iterable iterable, Object object) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(iterable2, "<this>");
        if (iterable2 instanceof Collection) {
            return CollectionsKt.plus((Collection)iterable, object);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CollectionsKt.addAll(arrayList, iterable);
        arrayList.add(object);
        return arrayList;
    }

    public static List plus(Collection collection, Object object) {
        ArrayList<Object> arrayList;
        Intrinsics.checkNotNullParameter(collection, "<this>");
        ArrayList<Object> arrayList2 = arrayList;
        arrayList2(collection.size() + 1);
        arrayList2.addAll(collection);
        arrayList.add(object);
        return arrayList;
    }

    public static List plus(Iterable iterable, Iterable iterable2) {
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        Intrinsics.checkNotNullParameter(iterable2, "elements");
        if (iterable instanceof Collection) {
            return CollectionsKt.plus((Collection)iterable, iterable2);
        }
        ArrayList arrayList = new ArrayList();
        CollectionsKt.addAll(arrayList, iterable);
        CollectionsKt.addAll(arrayList, iterable2);
        return arrayList;
    }

    public static List plus(Collection collection, Iterable iterable) {
        Iterable iterable2 = iterable;
        Intrinsics.checkNotNullParameter(collection, "<this>");
        Intrinsics.checkNotNullParameter(iterable2, "elements");
        if (iterable2 instanceof Collection) {
            int n = collection.size();
            collection = (Collection)iterable;
            ArrayList arrayList = new ArrayList(n + collection.size());
            arrayList.addAll(collection);
            arrayList.addAll(collection);
            return arrayList;
        }
        ArrayList arrayList = new ArrayList(collection);
        CollectionsKt.addAll(arrayList, iterable);
        return arrayList;
    }

    public static List zip(Iterable iterable, Iterable iterable2) {
        ArrayList<Pair> arrayList;
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        Intrinsics.checkNotNullParameter(iterable2, "other");
        Iterator iterator2 = iterable.iterator();
        Iterator iterator3 = iterable2.iterator();
        ArrayList<Pair> arrayList2 = arrayList;
        arrayList = new ArrayList<Pair>(Math.min(CollectionsKt.collectionSizeOrDefault(iterable, 10), CollectionsKt.collectionSizeOrDefault(iterable2, 10)));
        while (iterator2.hasNext() && iterator3.hasNext()) {
            arrayList2.add(TuplesKt.to(iterator2.next(), iterator3.next()));
        }
        return arrayList2;
    }

    public static final Appendable joinTo(Iterable iterable, Appendable appendable, CharSequence charSequence, CharSequence object, CharSequence charSequence2, int n, CharSequence charSequence3, Function1 function1) {
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        Intrinsics.checkNotNullParameter(appendable, "buffer");
        Intrinsics.checkNotNullParameter(charSequence, "separator");
        Intrinsics.checkNotNullParameter(object, "prefix");
        Intrinsics.checkNotNullParameter(charSequence2, "postfix");
        Intrinsics.checkNotNullParameter(charSequence3, "truncated");
        appendable.append((CharSequence)object);
        int n2 = 0;
        for (Object e : iterable) {
            if (++n2 > 1) {
                appendable.append(charSequence);
            }
            if (n >= 0 && n2 > n) break;
            StringsKt.appendElement(appendable, e, function1);
        }
        if (n >= 0 && n2 > n) {
            appendable.append(charSequence3);
        }
        Appendable appendable2 = appendable;
        appendable2.append(charSequence2);
        return appendable2;
    }

    public static /* synthetic */ Appendable joinTo$default(Iterable iterable, Appendable appendable, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charSequence = ", ";
        }
        if ((n2 & 4) != 0) {
            charSequence2 = "";
        }
        if ((n2 & 8) != 0) {
            charSequence3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            charSequence4 = "...";
        }
        if ((n2 & 0x40) != 0) {
            function1 = null;
        }
        return CollectionsKt___CollectionsKt.joinTo(iterable, appendable, charSequence, charSequence2, charSequence3, n, charSequence4, function1);
    }

    public static final String joinToString(Iterable iterable, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, Function1 function1) {
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        Intrinsics.checkNotNullParameter(charSequence, "separator");
        Intrinsics.checkNotNullParameter(charSequence2, "prefix");
        Intrinsics.checkNotNullParameter(charSequence3, "postfix");
        Intrinsics.checkNotNullParameter(charSequence4, "truncated");
        String string = ((StringBuilder)CollectionsKt___CollectionsKt.joinTo(iterable, new StringBuilder(), charSequence, charSequence2, charSequence3, n, charSequence4, function1)).toString();
        Intrinsics.checkNotNullExpressionValue(string, "joinTo(StringBuilder(), \u2026ed, transform).toString()");
        return string;
    }

    public static /* synthetic */ String joinToString$default(Iterable iterable, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charSequence = ", ";
        }
        if ((n2 & 2) != 0) {
            charSequence2 = "";
        }
        if ((n2 & 4) != 0) {
            charSequence3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            charSequence4 = "...";
        }
        if ((n2 & 0x20) != 0) {
            function1 = null;
        }
        return CollectionsKt___CollectionsKt.joinToString(iterable, charSequence, charSequence2, charSequence3, n, charSequence4, function1);
    }

    public static Sequence asSequence(Iterable iterable) {
        Intrinsics.checkNotNullParameter(iterable, "<this>");
        return new CollectionsKt___CollectionsKt$asSequence$$inlined$Sequence$1(iterable);
    }
}

