/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.internal.bind.ObjectTypeAdapter$1;
import com.google.gson.internal.bind.ObjectTypeAdapter$2;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.util.ArrayList;

public final class ObjectTypeAdapter
extends TypeAdapter {
    private static final TypeAdapterFactory DOUBLE_FACTORY = ObjectTypeAdapter.newFactory(ToNumberPolicy.DOUBLE);
    private final Gson gson;
    private final ToNumberStrategy toNumberStrategy;

    private ObjectTypeAdapter(Gson gson, ToNumberStrategy toNumberStrategy) {
        this.gson = gson;
        this.toNumberStrategy = toNumberStrategy;
    }

    private static TypeAdapterFactory newFactory(ToNumberStrategy toNumberStrategy) {
        return new ObjectTypeAdapter$1(toNumberStrategy);
    }

    public static TypeAdapterFactory getFactory(ToNumberStrategy toNumberStrategy) {
        if (toNumberStrategy == ToNumberPolicy.DOUBLE) {
            return DOUBLE_FACTORY;
        }
        return ObjectTypeAdapter.newFactory(toNumberStrategy);
    }

    /* synthetic */ ObjectTypeAdapter(Gson gson, ToNumberStrategy toNumberStrategy, ObjectTypeAdapter$1 objectTypeAdapter$1) {
        this(gson, toNumberStrategy);
    }

    @Override
    public Object read(JsonReader jsonReader) {
        ArrayList<Object> arrayList;
        switch (ObjectTypeAdapter$2.$SwitchMap$com$google$gson$stream$JsonToken[jsonReader.peek().ordinal()]) {
            default: {
                throw new IllegalStateException();
            }
            case 6: {
                jsonReader.nextNull();
                return null;
            }
            case 5: {
                return jsonReader.nextBoolean();
            }
            case 4: {
                return this.toNumberStrategy.readNumber(jsonReader);
            }
            case 3: {
                return jsonReader.nextString();
            }
            case 2: {
                LinkedTreeMap linkedTreeMap;
                LinkedTreeMap linkedTreeMap2 = linkedTreeMap;
                linkedTreeMap = new LinkedTreeMap();
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    String string = jsonReader.nextName();
                    linkedTreeMap2.put(string, this.read(jsonReader));
                }
                jsonReader.endObject();
                return linkedTreeMap2;
            }
            case 1: 
        }
        ArrayList<Object> arrayList2 = arrayList;
        arrayList = new ArrayList<Object>();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            arrayList2.add(this.read(jsonReader));
        }
        jsonReader.endArray();
        return arrayList2;
    }

    @Override
    public void write(JsonWriter jsonWriter, Object object) {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        TypeAdapter typeAdapter = ((ObjectTypeAdapter)typeAdapter).gson.getAdapter(object.getClass());
        if (typeAdapter instanceof ObjectTypeAdapter) {
            JsonWriter jsonWriter2 = jsonWriter;
            jsonWriter2.beginObject();
            jsonWriter2.endObject();
            return;
        }
        typeAdapter.write(jsonWriter, object);
    }
}

