/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.bind.JsonTreeWriter$1;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class JsonTreeWriter
extends JsonWriter {
    private static final Writer UNWRITABLE_WRITER = new JsonTreeWriter$1();
    private static final JsonPrimitive SENTINEL_CLOSED = new JsonPrimitive("closed");
    private final List stack = new ArrayList();
    private String pendingName;
    private JsonElement product = JsonNull.INSTANCE;

    public JsonTreeWriter() {
        super(UNWRITABLE_WRITER);
    }

    private JsonElement peek() {
        List list = this.stack;
        return (JsonElement)list.get(list.size() - 1);
    }

    private void put(JsonElement jsonElement) {
        block7: {
            block5: {
                block6: {
                    block4: {
                        if (((JsonTreeWriter)this).pendingName == null) break block4;
                        if (!jsonElement.isJsonNull() || ((JsonWriter)this).getSerializeNulls()) {
                            ((JsonObject)((JsonTreeWriter)this).peek()).add(((JsonTreeWriter)this).pendingName, jsonElement);
                        }
                        ((JsonTreeWriter)this).pendingName = null;
                        break block5;
                    }
                    if (!((JsonTreeWriter)this).stack.isEmpty()) break block6;
                    ((JsonTreeWriter)this).product = jsonElement;
                    break block5;
                }
                if (!((this = ((JsonTreeWriter)this).peek()) instanceof JsonArray)) break block7;
                ((JsonArray)this).add(jsonElement);
            }
            return;
        }
        throw new IllegalStateException();
    }

    public JsonElement get() {
        if (this.stack.isEmpty()) {
            return this.product;
        }
        throw new IllegalStateException("Expected one JSON element but was " + this.stack);
    }

    @Override
    public JsonWriter beginArray() {
        JsonArray jsonArray;
        JsonTreeWriter jsonTreeWriter = jsonArray2;
        JsonArray jsonArray2 = jsonArray;
        jsonTreeWriter.put(new JsonArray());
        jsonTreeWriter.stack.add(jsonArray2);
        return jsonTreeWriter;
    }

    @Override
    public JsonWriter endArray() {
        if (!this.stack.isEmpty() && this.pendingName == null) {
            if (this.peek() instanceof JsonArray) {
                JsonTreeWriter jsonTreeWriter = this;
                List list = jsonTreeWriter.stack;
                list.remove(list.size() - 1);
                return jsonTreeWriter;
            }
            throw new IllegalStateException();
        }
        throw new IllegalStateException();
    }

    @Override
    public JsonWriter beginObject() {
        JsonObject jsonObject;
        JsonTreeWriter jsonTreeWriter = jsonObject2;
        JsonObject jsonObject2 = jsonObject;
        jsonTreeWriter.put(new JsonObject());
        jsonTreeWriter.stack.add(jsonObject2);
        return jsonTreeWriter;
    }

    @Override
    public JsonWriter endObject() {
        if (!this.stack.isEmpty() && this.pendingName == null) {
            if (this.peek() instanceof JsonObject) {
                JsonTreeWriter jsonTreeWriter = this;
                List list = jsonTreeWriter.stack;
                list.remove(list.size() - 1);
                return jsonTreeWriter;
            }
            throw new IllegalStateException();
        }
        throw new IllegalStateException();
    }

    @Override
    public JsonWriter name(String string) {
        if (string != null) {
            if (!this.stack.isEmpty() && this.pendingName == null) {
                if (this.peek() instanceof JsonObject) {
                    this.pendingName = string;
                    return this;
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
        throw new NullPointerException("name == null");
    }

    @Override
    public JsonWriter value(String string) {
        JsonPrimitive jsonPrimitive;
        if (string == null) {
            return ((JsonTreeWriter)((Object)jsonPrimitive2)).nullValue();
        }
        JsonTreeWriter jsonTreeWriter = jsonPrimitive2;
        JsonPrimitive jsonPrimitive2 = jsonPrimitive;
        jsonPrimitive = new JsonPrimitive(string);
        jsonTreeWriter.put(jsonPrimitive2);
        return jsonTreeWriter;
    }

    @Override
    public JsonWriter nullValue() {
        JsonTreeWriter jsonTreeWriter = this;
        jsonTreeWriter.put(JsonNull.INSTANCE);
        return jsonTreeWriter;
    }

    @Override
    public JsonWriter value(boolean bl) {
        JsonTreeWriter jsonTreeWriter = this;
        jsonTreeWriter.put(new JsonPrimitive(bl));
        return jsonTreeWriter;
    }

    @Override
    public JsonWriter value(Boolean bl) {
        JsonPrimitive jsonPrimitive;
        if (bl == null) {
            return ((JsonTreeWriter)((Object)jsonPrimitive2)).nullValue();
        }
        JsonTreeWriter jsonTreeWriter = jsonPrimitive2;
        JsonPrimitive jsonPrimitive2 = jsonPrimitive;
        jsonPrimitive = new JsonPrimitive(bl);
        jsonTreeWriter.put(jsonPrimitive2);
        return jsonTreeWriter;
    }

    @Override
    public JsonWriter value(long l) {
        JsonTreeWriter jsonTreeWriter = this;
        jsonTreeWriter.put(new JsonPrimitive(l));
        return jsonTreeWriter;
    }

    @Override
    public JsonWriter value(Number number) {
        JsonPrimitive jsonPrimitive;
        double d;
        if (number == null) {
            return ((JsonTreeWriter)((Object)jsonPrimitive2)).nullValue();
        }
        if (!((JsonWriter)((Object)jsonPrimitive2)).isLenient() && (Double.isNaN(d = number.doubleValue()) || Double.isInfinite(d))) {
            throw new IllegalArgumentException("JSON forbids NaN and infinities: " + number);
        }
        JsonTreeWriter jsonTreeWriter = jsonPrimitive2;
        JsonPrimitive jsonPrimitive2 = jsonPrimitive;
        jsonPrimitive = new JsonPrimitive(number);
        jsonTreeWriter.put(jsonPrimitive2);
        return jsonTreeWriter;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        if (this.stack.isEmpty()) {
            this.stack.add(SENTINEL_CLOSED);
            return;
        }
        throw new IOException("Incomplete document");
    }
}

