/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.$Gson$Preconditions;
import com.google.gson.internal.JavaVersion;
import com.google.gson.internal.PreJava9DateFormatProvider;
import com.google.gson.internal.bind.DefaultDateTypeAdapter$1;
import com.google.gson.internal.bind.DefaultDateTypeAdapter$DateType;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class DefaultDateTypeAdapter
extends TypeAdapter {
    private final DefaultDateTypeAdapter$DateType dateType;
    private final List dateFormats;

    private DefaultDateTypeAdapter(DefaultDateTypeAdapter$DateType defaultDateTypeAdapter$DateType, String string) {
        ArrayList<Object> arrayList;
        ArrayList<Object> arrayList2;
        ArrayList<Object> arrayList3 = arrayList2 = arrayList;
        arrayList3();
        ((DefaultDateTypeAdapter)object).dateFormats = arrayList3;
        ((DefaultDateTypeAdapter)object).dateType = (DefaultDateTypeAdapter$DateType)$Gson$Preconditions.checkNotNull(defaultDateTypeAdapter$DateType);
        Object object = Locale.US;
        arrayList.add(new SimpleDateFormat(string, (Locale)object));
        if (!Locale.getDefault().equals(object)) {
            SimpleDateFormat simpleDateFormat;
            object = simpleDateFormat;
            simpleDateFormat = new SimpleDateFormat(string);
            arrayList2.add(object);
        }
    }

    private DefaultDateTypeAdapter(DefaultDateTypeAdapter$DateType defaultDateTypeAdapter$DateType, int n, int n2) {
        ArrayList<DateFormat> arrayList;
        ArrayList<DateFormat> arrayList2;
        ArrayList<DateFormat> arrayList3 = arrayList2 = arrayList;
        arrayList3();
        ((DefaultDateTypeAdapter)((Object)locale)).dateFormats = arrayList3;
        ((DefaultDateTypeAdapter)((Object)locale)).dateType = (DefaultDateTypeAdapter$DateType)$Gson$Preconditions.checkNotNull(defaultDateTypeAdapter$DateType);
        Locale locale = Locale.US;
        arrayList.add(DateFormat.getDateTimeInstance(n, n2, locale));
        if (!Locale.getDefault().equals(locale)) {
            arrayList2.add(DateFormat.getDateTimeInstance(n, n2));
        }
        if (JavaVersion.isJava9OrLater()) {
            arrayList2.add(PreJava9DateFormatProvider.getUSDateTimeFormat(n, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Date deserializeToDate(JsonReader jsonReader) {
        Object object;
        String string;
        DefaultDateTypeAdapter defaultDateTypeAdapter = string;
        string = jsonReader.nextString();
        List list = defaultDateTypeAdapter.dateFormats;
        synchronized (list) {
            Iterator iterator2 = defaultDateTypeAdapter.dateFormats.iterator();
            while (iterator2.hasNext()) {
                try {
                    return ((DateFormat)iterator2.next()).parse(string);
                }
                catch (ParseException parseException) {
                }
            }
            {
                object = string;
            }
        }
        try {
            return ISO8601Utils.parse((String)object, new ParsePosition(0));
        }
        catch (ParseException parseException) {
            throw new JsonSyntaxException("Failed parsing '" + (String)string + "' as Date; at path " + jsonReader.getPreviousPath(), parseException);
        }
    }

    /* synthetic */ DefaultDateTypeAdapter(DefaultDateTypeAdapter$DateType defaultDateTypeAdapter$DateType, String string, DefaultDateTypeAdapter$1 defaultDateTypeAdapter$1) {
        this(defaultDateTypeAdapter$DateType, string);
    }

    /* synthetic */ DefaultDateTypeAdapter(DefaultDateTypeAdapter$DateType defaultDateTypeAdapter$DateType, int n, int n2, DefaultDateTypeAdapter$1 defaultDateTypeAdapter$1) {
        this(defaultDateTypeAdapter$DateType, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(JsonWriter object, Date date) {
        Object object2;
        if (date == null) {
            ((JsonWriter)object).nullValue();
            return;
        }
        Object object3 = object;
        DefaultDateTypeAdapter defaultDateTypeAdapter = object2;
        object2 = (DateFormat)defaultDateTypeAdapter.dateFormats.get(0);
        object = defaultDateTypeAdapter.dateFormats;
        synchronized (object) {
            object2 = ((DateFormat)object2).format(date);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : object
            ((JsonWriter)object3).value((String)object2);
            return;
        }
    }

    @Override
    public Date read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        DefaultDateTypeAdapter defaultDateTypeAdapter = date;
        Date date = defaultDateTypeAdapter.deserializeToDate(jsonReader);
        return defaultDateTypeAdapter.dateType.deserialize(date);
    }

    public String toString() {
        DateFormat dateFormat = (DateFormat)((DefaultDateTypeAdapter)((Object)dateFormat)).dateFormats.get(0);
        if (dateFormat instanceof SimpleDateFormat) {
            return "DefaultDateTypeAdapter(" + ((SimpleDateFormat)dateFormat).toPattern() + ')';
        }
        return "DefaultDateTypeAdapter(" + dateFormat.getClass().getSimpleName() + ')';
    }
}

