/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.Since;
import com.google.gson.annotations.Until;
import com.google.gson.internal.Excluder$1;
import com.google.gson.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Excluder
implements TypeAdapterFactory,
Cloneable {
    public static final Excluder DEFAULT = new Excluder();
    private double version = -1.0;
    private int modifiers = 136;
    private boolean serializeInnerClasses = true;
    private boolean requireExpose;
    private List serializationStrategies = Collections.emptyList();
    private List deserializationStrategies = Collections.emptyList();

    private boolean excludeClassChecks(Class clazz) {
        if (this.version != -1.0) {
            Class clazz2 = clazz;
            Since since = clazz2.getAnnotation(Since.class);
            if (!this.isValidVersion(since, clazz2.getAnnotation(Until.class))) {
                return true;
            }
        }
        if (!this.serializeInnerClasses && this.isInnerClass(clazz)) {
            return true;
        }
        return this.isAnonymousOrNonStaticLocal(clazz);
    }

    private boolean excludeClassInStrategy(Class clazz, boolean bl) {
        Iterator iterator2 = (bl ? ((Excluder)((Object)iterator2)).serializationStrategies : ((Excluder)((Object)iterator2)).deserializationStrategies).iterator();
        while (iterator2.hasNext()) {
            if (!((ExclusionStrategy)iterator2.next()).shouldSkipClass(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnonymousOrNonStaticLocal(Class clazz) {
        return !Enum.class.isAssignableFrom(clazz) && !this.isStatic(clazz) && (clazz.isAnonymousClass() || clazz.isLocalClass());
    }

    private boolean isInnerClass(Class clazz) {
        return clazz.isMemberClass() && !this.isStatic(clazz);
    }

    private boolean isStatic(Class clazz) {
        return (clazz.getModifiers() & 8) != 0;
    }

    private boolean isValidVersion(Since since, Until until) {
        return this.isValidSince(since) && this.isValidUntil(until);
    }

    private boolean isValidSince(Since since) {
        return since == null || !(since.value() > this.version);
    }

    private boolean isValidUntil(Until until) {
        return until == null || !(until.value() <= this.version);
    }

    protected Excluder clone() {
        try {
            return (Excluder)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    @Override
    public TypeAdapter create(Gson gson, TypeToken typeToken) {
        Class clazz = typeToken.getRawType();
        boolean bl = this.excludeClassChecks(clazz);
        boolean bl2 = bl || this.excludeClassInStrategy(clazz, true);
        boolean bl3 = bl || this.excludeClassInStrategy(clazz, false);
        if (!bl2 && !bl3) {
            return null;
        }
        return new Excluder$1(this, bl3, bl2, gson, typeToken);
    }

    public boolean excludeField(Field object, boolean bl) {
        Annotation annotation;
        if ((((Excluder)object2).modifiers & ((Field)object).getModifiers()) != 0) {
            return true;
        }
        if (((Excluder)object2).version != -1.0) {
            Field field = object;
            annotation = field.getAnnotation(Since.class);
            if (!((Excluder)object2).isValidVersion((Since)annotation, field.getAnnotation(Until.class))) {
                return true;
            }
        }
        if (((Field)object).isSynthetic()) {
            return true;
        }
        if (((Excluder)object2).requireExpose && ((annotation = ((Field)object).getAnnotation(Expose.class)) == null || (bl ? !annotation.serialize() : !annotation.deserialize()))) {
            return true;
        }
        if (!((Excluder)object2).serializeInnerClasses && ((Excluder)object2).isInnerClass(((Field)object).getType())) {
            return true;
        }
        if (((Excluder)object2).isAnonymousOrNonStaticLocal(((Field)object).getType())) {
            return true;
        }
        Object object2 = bl ? ((Excluder)object2).serializationStrategies : ((Excluder)object2).deserializationStrategies;
        if (!object2.isEmpty()) {
            FieldAttributes fieldAttributes;
            Object object3 = object2;
            object2 = fieldAttributes;
            fieldAttributes = new FieldAttributes((Field)object);
            object = object3.iterator();
            while (object.hasNext()) {
                if (!((ExclusionStrategy)object.next()).shouldSkipField((FieldAttributes)object2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean excludeClass(Class clazz, boolean bl) {
        return this.excludeClassChecks(clazz) || this.excludeClassInStrategy(clazz, bl);
    }
}

