/*
 * Decompiled with CFR 0.152.
 */
package org.polymc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.polymc.LauncherFactory;
import org.polymc.exception.ParseException;
import org.polymc.utils.Parameters;

public final class EntryPoint {
    private static final Logger LOGGER = Logger.getLogger("EntryPoint");
    private final Parameters params = new Parameters();

    public static void main(String[] stringArray) {
        EntryPoint entryPoint = new EntryPoint();
        int n = entryPoint.listen();
        if (n != 0) {
            LOGGER.info("Exiting with " + n);
            System.exit(n);
        }
    }

    private Action parseLine(String string) throws ParseException {
        String[] stringArray = string.split("\\s+", 2);
        if (stringArray.length == 0) {
            throw new ParseException("Unexpected empty string!");
        }
        switch (stringArray[0]) {
            case "launch": {
                return Action.Launch;
            }
            case "abort": {
                return Action.Abort;
            }
        }
        if (stringArray.length != 2) {
            throw new ParseException("Error while parsing:" + string);
        }
        this.params.add(stringArray[0], stringArray[1]);
        return Action.Proceed;
    }

    public int listen() {
        Object object;
        Action action = Action.Proceed;
        try {
            object = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                while (action == Action.Proceed) {
                    String string = ((BufferedReader)object).readLine();
                    if (string != null) {
                        action = this.parseLine(string);
                        continue;
                    }
                    action = Action.Abort;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((BufferedReader)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((BufferedReader)object).close();
                    }
                }
            }
        }
        catch (IOException | ParseException exception) {
            LOGGER.log(Level.SEVERE, "Launcher ABORT due to exception:", exception);
            return 1;
        }
        if (action == Action.Abort) {
            LOGGER.info("Launch aborted by the launcher.");
            return 1;
        }
        try {
            object = LauncherFactory.getInstance().createLauncher(this.params);
            object.launch();
            return 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.log(Level.SEVERE, "Wrong argument.", illegalArgumentException);
            return 1;
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Exception caught from launcher.", exception);
            return 1;
        }
    }

    private static enum Action {
        Proceed,
        Launch,
        Abort;

    }
}

